/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.util.StringBuilderPool;

public final class StringUtils {
    private StringUtils() {
    }

    public static ByteBuffer charSequence2ByteBuffer(CharSequence cs, Charset charset) {
        return charset.encode(CharBuffer.wrap(cs));
    }

    public static byte[] byteBuffer2ByteArray(ByteBuffer bb) {
        byte[] rawBase = new byte[bb.remaining()];
        bb.get(rawBase);
        return rawBase;
    }

    public static byte[] charSequence2Bytes(CharSequence sb, Charset charset) {
        ByteBuffer bb = StringUtils.charSequence2ByteBuffer(sb, charset);
        return StringUtils.byteBuffer2ByteArray(bb);
    }

    public static String toHexString(byte[] data) {
        StringBuilder buffer = StringBuilderPool.DEFAULT.stringBuilder();
        for (byte aData : data) {
            buffer.append(Integer.toHexString((aData & 0xF0) >>> 4));
            buffer.append(Integer.toHexString(aData & 0xF));
        }
        return buffer.toString();
    }

    public static void appendBase16(StringBuilder buf, byte[] bytes) {
        int base = 16;
        for (byte b : bytes) {
            int bi = 0xFF & b;
            int c = 48 + bi / base % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bi % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
        }
    }
}

