/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.exception.TooManyConnectionsPerHostException;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.InfiniteSemaphore;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.util.ThrowableUtil;

public class PerHostConnectionSemaphore
implements ConnectionSemaphore {
    protected final ConcurrentHashMap<Object, Semaphore> freeChannelsPerHost = new ConcurrentHashMap();
    protected final int maxConnectionsPerHost;
    protected final IOException tooManyConnectionsPerHost;
    protected final int acquireTimeout;

    PerHostConnectionSemaphore(int maxConnectionsPerHost, int acquireTimeout) {
        this.tooManyConnectionsPerHost = ThrowableUtil.unknownStackTrace(new TooManyConnectionsPerHostException(maxConnectionsPerHost), PerHostConnectionSemaphore.class, "acquireChannelLock");
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.acquireTimeout = Math.max(0, acquireTimeout);
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        try {
            if (!this.getFreeConnectionsForHost(partitionKey).tryAcquire(this.acquireTimeout, TimeUnit.MILLISECONDS)) {
                throw this.tooManyConnectionsPerHost;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.getFreeConnectionsForHost(partitionKey).release();
    }

    protected Semaphore getFreeConnectionsForHost(Object partitionKey) {
        return this.maxConnectionsPerHost > 0 ? this.freeChannelsPerHost.computeIfAbsent(partitionKey, pk -> new Semaphore(this.maxConnectionsPerHost)) : InfiniteSemaphore.INSTANCE;
    }
}

