/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.exception.TooManyConnectionsException;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.InfiniteSemaphore;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.util.ThrowableUtil;

public class MaxConnectionSemaphore
implements ConnectionSemaphore {
    protected final Semaphore freeChannels;
    protected final IOException tooManyConnections;
    protected final int acquireTimeout;

    MaxConnectionSemaphore(int maxConnections, int acquireTimeout) {
        this.tooManyConnections = ThrowableUtil.unknownStackTrace(new TooManyConnectionsException(maxConnections), MaxConnectionSemaphore.class, "acquireChannelLock");
        this.freeChannels = maxConnections > 0 ? new Semaphore(maxConnections) : InfiniteSemaphore.INSTANCE;
        this.acquireTimeout = Math.max(0, acquireTimeout);
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        try {
            if (!this.freeChannels.tryAcquire(this.acquireTimeout, TimeUnit.MILLISECONDS)) {
                throw this.tooManyConnections;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.freeChannels.release();
    }
}

