/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.MaxConnectionSemaphore;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.netty.channel.PerHostConnectionSemaphore;

public class CombinedConnectionSemaphore
extends PerHostConnectionSemaphore {
    protected final MaxConnectionSemaphore globalMaxConnectionSemaphore;

    CombinedConnectionSemaphore(int maxConnections, int maxConnectionsPerHost, int acquireTimeout) {
        super(maxConnectionsPerHost, acquireTimeout);
        this.globalMaxConnectionSemaphore = new MaxConnectionSemaphore(maxConnections, acquireTimeout);
    }

    @Override
    public void acquireChannelLock(Object partitionKey) throws IOException {
        long remainingTime = this.acquireTimeout > 0 ? this.acquireGlobalTimed(partitionKey) : this.acquireGlobal(partitionKey);
        try {
            if (remainingTime < 0L || !this.getFreeConnectionsForHost(partitionKey).tryAcquire(remainingTime, TimeUnit.MILLISECONDS)) {
                this.releaseGlobal(partitionKey);
                throw this.tooManyConnectionsPerHost;
            }
        }
        catch (InterruptedException e) {
            this.releaseGlobal(partitionKey);
            throw new RuntimeException(e);
        }
    }

    protected void releaseGlobal(Object partitionKey) {
        this.globalMaxConnectionSemaphore.releaseChannelLock(partitionKey);
    }

    protected long acquireGlobal(Object partitionKey) throws IOException {
        this.globalMaxConnectionSemaphore.acquireChannelLock(partitionKey);
        return 0L;
    }

    protected long acquireGlobalTimed(Object partitionKey) throws IOException {
        long beforeGlobalAcquire = System.currentTimeMillis();
        this.acquireGlobal(partitionKey);
        long lockTime = System.currentTimeMillis() - beforeGlobalAcquire;
        return (long)this.acquireTimeout - lockTime;
    }

    @Override
    public void releaseChannelLock(Object partitionKey) {
        this.globalMaxConnectionSemaphore.releaseChannelLock(partitionKey);
        super.releaseChannelLock(partitionKey);
    }
}

