/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.config.AsyncHttpClientConfigHelper;

public final class AsyncHttpClientConfigDefaults {
    public static final String ASYNC_CLIENT_CONFIG_ROOT = "org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.";
    public static final String THREAD_POOL_NAME_CONFIG = "threadPoolName";
    public static final String MAX_CONNECTIONS_CONFIG = "maxConnections";
    public static final String MAX_CONNECTIONS_PER_HOST_CONFIG = "maxConnectionsPerHost";
    public static final String ACQUIRE_FREE_CHANNEL_TIMEOUT = "acquireFreeChannelTimeout";
    public static final String CONNECTION_TIMEOUT_CONFIG = "connectTimeout";
    public static final String POOLED_CONNECTION_IDLE_TIMEOUT_CONFIG = "pooledConnectionIdleTimeout";
    public static final String CONNECTION_POOL_CLEANER_PERIOD_CONFIG = "connectionPoolCleanerPeriod";
    public static final String READ_TIMEOUT_CONFIG = "readTimeout";
    public static final String REQUEST_TIMEOUT_CONFIG = "requestTimeout";
    public static final String CONNECTION_TTL_CONFIG = "connectionTtl";
    public static final String FOLLOW_REDIRECT_CONFIG = "followRedirect";
    public static final String MAX_REDIRECTS_CONFIG = "maxRedirects";
    public static final String COMPRESSION_ENFORCED_CONFIG = "compressionEnforced";
    public static final String USER_AGENT_CONFIG = "userAgent";
    public static final String ENABLED_PROTOCOLS_CONFIG = "enabledProtocols";
    public static final String ENABLED_CIPHER_SUITES_CONFIG = "enabledCipherSuites";
    public static final String FILTER_INSECURE_CIPHER_SUITES_CONFIG = "filterInsecureCipherSuites";
    public static final String USE_PROXY_SELECTOR_CONFIG = "useProxySelector";
    public static final String USE_PROXY_PROPERTIES_CONFIG = "useProxyProperties";
    public static final String VALIDATE_RESPONSE_HEADERS_CONFIG = "validateResponseHeaders";
    public static final String AGGREGATE_WEBSOCKET_FRAME_FRAGMENTS_CONFIG = "aggregateWebSocketFrameFragments";
    public static final String ENABLE_WEBSOCKET_COMPRESSION_CONFIG = "enableWebSocketCompression";
    public static final String STRICT_302_HANDLING_CONFIG = "strict302Handling";
    public static final String KEEP_ALIVE_CONFIG = "keepAlive";
    public static final String MAX_REQUEST_RETRY_CONFIG = "maxRequestRetry";
    public static final String DISABLE_URL_ENCODING_FOR_BOUND_REQUESTS_CONFIG = "disableUrlEncodingForBoundRequests";
    public static final String USE_LAX_COOKIE_ENCODER_CONFIG = "useLaxCookieEncoder";
    public static final String USE_OPEN_SSL_CONFIG = "useOpenSsl";
    public static final String USE_INSECURE_TRUST_MANAGER_CONFIG = "useInsecureTrustManager";
    public static final String DISABLE_HTTPS_ENDPOINT_IDENTIFICATION_ALGORITHM_CONFIG = "disableHttpsEndpointIdentificationAlgorithm";
    public static final String SSL_SESSION_CACHE_SIZE_CONFIG = "sslSessionCacheSize";
    public static final String SSL_SESSION_TIMEOUT_CONFIG = "sslSessionTimeout";
    public static final String TCP_NO_DELAY_CONFIG = "tcpNoDelay";
    public static final String SO_REUSE_ADDRESS_CONFIG = "soReuseAddress";
    public static final String SO_KEEP_ALIVE_CONFIG = "soKeepAlive";
    public static final String SO_LINGER_CONFIG = "soLinger";
    public static final String SO_SND_BUF_CONFIG = "soSndBuf";
    public static final String SO_RCV_BUF_CONFIG = "soRcvBuf";
    public static final String HTTP_CLIENT_CODEC_MAX_INITIAL_LINE_LENGTH_CONFIG = "httpClientCodecMaxInitialLineLength";
    public static final String HTTP_CLIENT_CODEC_MAX_HEADER_SIZE_CONFIG = "httpClientCodecMaxHeaderSize";
    public static final String HTTP_CLIENT_CODEC_MAX_CHUNK_SIZE_CONFIG = "httpClientCodecMaxChunkSize";
    public static final String HTTP_CLIENT_CODEC_INITIAL_BUFFER_SIZE_CONFIG = "httpClientCodecInitialBufferSize";
    public static final String DISABLE_ZERO_COPY_CONFIG = "disableZeroCopy";
    public static final String HANDSHAKE_TIMEOUT_CONFIG = "handshakeTimeout";
    public static final String CHUNKED_FILE_CHUNK_SIZE_CONFIG = "chunkedFileChunkSize";
    public static final String WEBSOCKET_MAX_BUFFER_SIZE_CONFIG = "webSocketMaxBufferSize";
    public static final String WEBSOCKET_MAX_FRAME_SIZE_CONFIG = "webSocketMaxFrameSize";
    public static final String KEEP_ENCODING_HEADER_CONFIG = "keepEncodingHeader";
    public static final String SHUTDOWN_QUIET_PERIOD_CONFIG = "shutdownQuietPeriod";
    public static final String SHUTDOWN_TIMEOUT_CONFIG = "shutdownTimeout";
    public static final String USE_NATIVE_TRANSPORT_CONFIG = "useNativeTransport";
    public static final String IO_THREADS_COUNT_CONFIG = "ioThreadsCount";
    public static final String HASHED_WHEEL_TIMER_TICK_DURATION = "hashedWheelTimerTickDuration";
    public static final String HASHED_WHEEL_TIMER_SIZE = "hashedWheelTimerSize";
    public static final String EXPIRED_COOKIE_EVICTION_DELAY = "expiredCookieEvictionDelay";
    public static final String AHC_VERSION;

    private AsyncHttpClientConfigDefaults() {
    }

    public static String defaultThreadPoolName() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getString("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.threadPoolName");
    }

    public static int defaultMaxConnections() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.maxConnections");
    }

    public static int defaultMaxConnectionsPerHost() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.maxConnectionsPerHost");
    }

    public static int defaultAcquireFreeChannelTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.acquireFreeChannelTimeout");
    }

    public static int defaultConnectTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.connectTimeout");
    }

    public static int defaultPooledConnectionIdleTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.pooledConnectionIdleTimeout");
    }

    public static int defaultConnectionPoolCleanerPeriod() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.connectionPoolCleanerPeriod");
    }

    public static int defaultReadTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.readTimeout");
    }

    public static int defaultRequestTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.requestTimeout");
    }

    public static int defaultConnectionTtl() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.connectionTtl");
    }

    public static boolean defaultFollowRedirect() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.followRedirect");
    }

    public static int defaultMaxRedirects() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.maxRedirects");
    }

    public static boolean defaultCompressionEnforced() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.compressionEnforced");
    }

    public static String defaultUserAgent() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getString("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.userAgent");
    }

    public static String[] defaultEnabledProtocols() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getStringArray("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.enabledProtocols");
    }

    public static String[] defaultEnabledCipherSuites() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getStringArray("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.enabledCipherSuites");
    }

    public static boolean defaultFilterInsecureCipherSuites() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.filterInsecureCipherSuites");
    }

    public static boolean defaultUseProxySelector() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useProxySelector");
    }

    public static boolean defaultUseProxyProperties() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useProxyProperties");
    }

    public static boolean defaultValidateResponseHeaders() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.validateResponseHeaders");
    }

    public static boolean defaultAggregateWebSocketFrameFragments() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.aggregateWebSocketFrameFragments");
    }

    public static boolean defaultEnableWebSocketCompression() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.enableWebSocketCompression");
    }

    public static boolean defaultStrict302Handling() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.strict302Handling");
    }

    public static boolean defaultKeepAlive() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.keepAlive");
    }

    public static int defaultMaxRequestRetry() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.maxRequestRetry");
    }

    public static boolean defaultDisableUrlEncodingForBoundRequests() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.disableUrlEncodingForBoundRequests");
    }

    public static boolean defaultUseLaxCookieEncoder() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useLaxCookieEncoder");
    }

    public static boolean defaultUseOpenSsl() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useOpenSsl");
    }

    public static boolean defaultUseInsecureTrustManager() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useInsecureTrustManager");
    }

    public static boolean defaultDisableHttpsEndpointIdentificationAlgorithm() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.disableHttpsEndpointIdentificationAlgorithm");
    }

    public static int defaultSslSessionCacheSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.sslSessionCacheSize");
    }

    public static int defaultSslSessionTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.sslSessionTimeout");
    }

    public static boolean defaultTcpNoDelay() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.tcpNoDelay");
    }

    public static boolean defaultSoReuseAddress() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.soReuseAddress");
    }

    public static boolean defaultSoKeepAlive() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.soKeepAlive");
    }

    public static int defaultSoLinger() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.soLinger");
    }

    public static int defaultSoSndBuf() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.soSndBuf");
    }

    public static int defaultSoRcvBuf() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.soRcvBuf");
    }

    public static int defaultHttpClientCodecMaxInitialLineLength() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.httpClientCodecMaxInitialLineLength");
    }

    public static int defaultHttpClientCodecMaxHeaderSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.httpClientCodecMaxHeaderSize");
    }

    public static int defaultHttpClientCodecMaxChunkSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.httpClientCodecMaxChunkSize");
    }

    public static int defaultHttpClientCodecInitialBufferSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.httpClientCodecInitialBufferSize");
    }

    public static boolean defaultDisableZeroCopy() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.disableZeroCopy");
    }

    public static int defaultHandshakeTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.handshakeTimeout");
    }

    public static int defaultChunkedFileChunkSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.chunkedFileChunkSize");
    }

    public static int defaultWebSocketMaxBufferSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.webSocketMaxBufferSize");
    }

    public static int defaultWebSocketMaxFrameSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.webSocketMaxFrameSize");
    }

    public static boolean defaultKeepEncodingHeader() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.keepEncodingHeader");
    }

    public static int defaultShutdownQuietPeriod() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.shutdownQuietPeriod");
    }

    public static int defaultShutdownTimeout() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.shutdownTimeout");
    }

    public static boolean defaultUseNativeTransport() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getBoolean("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.useNativeTransport");
    }

    public static int defaultIoThreadsCount() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.ioThreadsCount");
    }

    public static int defaultHashedWheelTimerTickDuration() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.hashedWheelTimerTickDuration");
    }

    public static int defaultHashedWheelTimerSize() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.hashedWheelTimerSize");
    }

    public static int defaultExpiredCookieEvictionDelay() {
        return AsyncHttpClientConfigHelper.getAsyncHttpClientConfig().getInt("org.apache.pulsar.v3_0_8.shade.org.asynchttpclient.expiredCookieEvictionDelay");
    }

    static {
        try (InputStream is = AsyncHttpClientConfigDefaults.class.getResourceAsStream("ahc-version.properties");){
            Properties prop = new Properties();
            prop.load(is);
            AHC_VERSION = prop.getProperty("ahc.version", "UNKNOWN");
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

