/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.apache.pulsar.policies.data.loadbalancer;

import org.apache.pulsar.v3_0_8.shade.org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;

public class TimeAverageMessageData {
    private int maxSamples;
    private int numSamples;
    private double msgThroughputIn;
    private double msgThroughputOut;
    private double msgRateIn;
    private double msgRateOut;

    public TimeAverageMessageData() {
    }

    public TimeAverageMessageData(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    public TimeAverageMessageData(int maxSamples, NamespaceBundleStats defaultStats) {
        this.maxSamples = maxSamples;
        this.msgThroughputIn = defaultStats.msgThroughputIn;
        this.msgThroughputOut = defaultStats.msgThroughputOut;
        this.msgRateIn = defaultStats.msgRateIn;
        this.msgRateOut = defaultStats.msgRateOut;
    }

    public void update(double newMsgThroughputIn, double newMsgThroughputOut, double newMsgRateIn, double newMsgRateOut) {
        this.numSamples = Math.min(this.numSamples + 1, this.maxSamples);
        this.msgThroughputIn = this.getUpdatedValue(this.msgThroughputIn, newMsgThroughputIn);
        this.msgThroughputOut = this.getUpdatedValue(this.msgThroughputOut, newMsgThroughputOut);
        this.msgRateIn = this.getUpdatedValue(this.msgRateIn, newMsgRateIn);
        this.msgRateOut = this.getUpdatedValue(this.msgRateOut, newMsgRateOut);
    }

    public void update(NamespaceBundleStats newSample) {
        this.update(newSample.msgThroughputIn, newSample.msgThroughputOut, newSample.msgRateIn, newSample.msgRateOut);
    }

    private double getUpdatedValue(double oldAverage, double newSample) {
        return ((double)(this.numSamples - 1) * oldAverage + newSample) / (double)this.numSamples;
    }

    public int getMaxSamples() {
        return this.maxSamples;
    }

    public void setMaxSamples(int maxSamples) {
        this.maxSamples = maxSamples;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public double totalMsgRate() {
        return this.msgRateIn + this.msgRateOut;
    }

    public double totalMsgThroughput() {
        return this.msgThroughputIn + this.msgThroughputOut;
    }
}

