/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree;

import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ViewNode;

public class OverrideCombiner
extends NodeCombiner {
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ViewNode result = this.createViewNode();
        result.setName(node1.getName());
        for (ConfigurationNode child : node1.getChildren()) {
            ConfigurationNode child2 = this.canCombine(node1, node2, child);
            if (child2 != null) {
                result.addChild(this.combine(child, child2));
                continue;
            }
            result.addChild(child);
        }
        for (ConfigurationNode child : node2.getChildren()) {
            if (node1.getChildrenCount(child.getName()) >= 1) continue;
            result.addChild(child);
        }
        this.addAttributes(result, node1, node2);
        result.setValue(node1.getValue() != null ? node1.getValue() : node2.getValue());
        return result;
    }

    protected void addAttributes(ViewNode result, ConfigurationNode node1, ConfigurationNode node2) {
        result.appendAttributes(node1);
        for (ConfigurationNode attr : node2.getAttributes()) {
            if (node1.getAttributeCount(attr.getName()) != 0) continue;
            result.addAttribute(attr);
        }
    }

    protected ConfigurationNode canCombine(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child) {
        if (node2.getChildrenCount(child.getName()) == 1 && node1.getChildrenCount(child.getName()) == 1 && !this.isListNode(child)) {
            return node2.getChildren(child.getName()).get(0);
        }
        return null;
    }
}

