/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.ConfigurationKey;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.PropertyConverter;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ConfigurationNodeVisitorAdapter;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.NodeAddData;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.configuration.tree.ViewNode;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalConfiguration
extends AbstractConfiguration
implements Serializable,
Cloneable {
    public static final int EVENT_CLEAR_TREE = 10;
    public static final int EVENT_ADD_NODES = 11;
    public static final int EVENT_SUBNODE_CHANGED = 12;
    private static final long serialVersionUID = 3373812230395363192L;
    private static ExpressionEngine defaultExpressionEngine;
    private Node root;
    private ConfigurationNode rootNode;
    private transient ExpressionEngine expressionEngine;

    public HierarchicalConfiguration() {
        this.setRootNode(new Node());
    }

    public HierarchicalConfiguration(HierarchicalConfiguration c) {
        this();
        if (c != null) {
            CloneVisitor visitor = new CloneVisitor();
            c.getRootNode().visit(visitor);
            this.setRootNode(visitor.getClone());
        }
    }

    public Object getReloadLock() {
        return this;
    }

    public Node getRoot() {
        if (this.root == null && this.rootNode != null) {
            return new Node(this.rootNode);
        }
        return this.root;
    }

    public void setRoot(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.root = node;
        this.rootNode = null;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode != null ? this.rootNode : this.root;
    }

    public void setRootNode(ConfigurationNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.rootNode = rootNode;
        this.root = rootNode instanceof Node ? (Node)rootNode : null;
    }

    public static synchronized ExpressionEngine getDefaultExpressionEngine() {
        if (defaultExpressionEngine == null) {
            defaultExpressionEngine = new DefaultExpressionEngine();
        }
        return defaultExpressionEngine;
    }

    public static synchronized void setDefaultExpressionEngine(ExpressionEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Default expression engine must not be null!");
        }
        defaultExpressionEngine = engine;
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine != null ? this.expressionEngine : HierarchicalConfiguration.getDefaultExpressionEngine();
    }

    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        this.expressionEngine = expressionEngine;
    }

    @Override
    public Object getProperty(String key) {
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        if (nodes.size() == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (ConfigurationNode node : nodes) {
            if (node.getValue() == null) continue;
            list.add(node.getValue());
        }
        if (list.size() < 1) {
            return null;
        }
        return list.size() == 1 ? list.get(0) : list;
    }

    @Override
    protected void addPropertyDirect(String key, Object obj) {
        NodeAddData data = this.getExpressionEngine().prepareAdd(this.getRootNode(), key);
        ConfigurationNode node = this.processNodeAddData(data);
        node.setValue(obj);
    }

    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        this.fireEvent(11, key, nodes, true);
        List<ConfigurationNode> target = this.fetchNodeList(key);
        ConfigurationNode parent = target.size() == 1 ? target.get(0) : this.processNodeAddData(this.getExpressionEngine().prepareAdd(this.getRootNode(), key));
        if (parent.isAttribute()) {
            throw new IllegalArgumentException("Cannot add nodes to an attribute node!");
        }
        for (ConfigurationNode configurationNode : nodes) {
            if (configurationNode.isAttribute()) {
                parent.addAttribute(configurationNode);
            } else {
                parent.addChild(configurationNode);
            }
            HierarchicalConfiguration.clearReferences(configurationNode);
        }
        this.fireEvent(11, key, nodes, false);
    }

    @Override
    public boolean isEmpty() {
        return !this.nodeDefined(this.getRootNode());
    }

    @Override
    public Configuration subset(String prefix) {
        List<ConfigurationNode> nodes = this.fetchNodeList(prefix);
        if (nodes.isEmpty()) {
            return new HierarchicalConfiguration();
        }
        final HierarchicalConfiguration parent = this;
        HierarchicalConfiguration result = new HierarchicalConfiguration(){

            protected Object interpolate(Object value) {
                return parent.interpolate(value);
            }
        };
        CloneVisitor visitor = new CloneVisitor();
        Object value = null;
        int valueCount = 0;
        for (ConfigurationNode nd : nodes) {
            if (nd.getValue() != null) {
                value = nd.getValue();
                ++valueCount;
            }
            nd.visit(visitor);
            for (ConfigurationNode c : visitor.getClone().getChildren()) {
                result.getRootNode().addChild(c);
            }
            for (ConfigurationNode attr : visitor.getClone().getAttributes()) {
                result.getRootNode().addAttribute(attr);
            }
        }
        if (valueCount == 1) {
            result.getRootNode().setValue(value);
        }
        return result.isEmpty() ? new HierarchicalConfiguration() : result;
    }

    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        if (nodes.size() != 1) {
            throw new IllegalArgumentException("Passed in key must select exactly one node: " + key);
        }
        return supportUpdates ? this.createSubnodeConfiguration(nodes.get(0), key) : this.createSubnodeConfiguration(nodes.get(0));
    }

    public SubnodeConfiguration configurationAt(String key) {
        return this.configurationAt(key, false);
    }

    public List<HierarchicalConfiguration> configurationsAt(String key) {
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        ArrayList<HierarchicalConfiguration> configs = new ArrayList<HierarchicalConfiguration>(nodes.size());
        for (ConfigurationNode node : nodes) {
            configs.add(this.createSubnodeConfiguration(node));
        }
        return configs;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node) {
        SubnodeConfiguration result = new SubnodeConfiguration(this, node);
        this.registerSubnodeConfiguration(result);
        return result;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node, String subnodeKey) {
        SubnodeConfiguration result = this.createSubnodeConfiguration(node);
        result.setSubnodeKey(subnodeKey);
        return result;
    }

    protected void subnodeConfigurationChanged(ConfigurationEvent event) {
        this.fireEvent(12, null, event, event.isBeforeUpdate());
    }

    void registerSubnodeConfiguration(SubnodeConfiguration config) {
        config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                HierarchicalConfiguration.this.subnodeConfigurationChanged(event);
            }
        });
    }

    @Override
    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.fireEvent(3, key, value, true);
        Iterator<ConfigurationNode> itNodes = this.fetchNodeList(key).iterator();
        Iterator<Object> itValues = !this.isDelimiterParsingDisabled() || !(value instanceof String) ? PropertyConverter.toIterator(value, this.getListDelimiter()) : Collections.singleton(value).iterator();
        while (itNodes.hasNext() && itValues.hasNext()) {
            itNodes.next().setValue(itValues.next());
        }
        while (itValues.hasNext()) {
            this.addPropertyDirect(key, itValues.next());
        }
        while (itNodes.hasNext()) {
            this.clearNode(itNodes.next());
        }
        this.fireEvent(3, key, value, false);
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.getRootNode().removeAttributes();
        this.getRootNode().removeChildren();
        this.getRootNode().setValue(null);
        this.fireEvent(4, null, null, false);
    }

    public void clearTree(String key) {
        this.fireEvent(10, key, null, true);
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        for (ConfigurationNode node : nodes) {
            this.removeNode(node);
        }
        this.fireEvent(10, key, nodes, false);
    }

    @Override
    public void clearProperty(String key) {
        this.fireEvent(2, key, null, true);
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        for (ConfigurationNode node : nodes) {
            this.clearNode(node);
        }
        this.fireEvent(2, key, null, false);
    }

    @Override
    public Iterator<String> getKeys() {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor();
        this.getRootNode().visit(visitor);
        return visitor.getKeyList().iterator();
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        DefinedKeysVisitor visitor = new DefinedKeysVisitor(prefix);
        if (this.containsKey(prefix)) {
            visitor.getKeyList().add(prefix);
        }
        List<ConfigurationNode> nodes = this.fetchNodeList(prefix);
        for (ConfigurationNode node : nodes) {
            for (ConfigurationNode c : node.getChildren()) {
                c.visit(visitor);
            }
            for (ConfigurationNode attr : node.getAttributes()) {
                attr.visit(visitor);
            }
        }
        return visitor.getKeyList().iterator();
    }

    public int getMaxIndex(String key) {
        return this.fetchNodeList(key).size() - 1;
    }

    @Override
    public Object clone() {
        try {
            HierarchicalConfiguration copy = (HierarchicalConfiguration)super.clone();
            CloneVisitor v = new CloneVisitor();
            this.getRootNode().visit(v);
            copy.setRootNode(v.getClone());
            return copy;
        }
        catch (CloneNotSupportedException cex) {
            throw new ConfigurationRuntimeException(cex);
        }
    }

    @Override
    public Configuration interpolatedConfiguration() {
        HierarchicalConfiguration c = (HierarchicalConfiguration)this.clone();
        c.getRootNode().visit(new ConfigurationNodeVisitorAdapter(){

            public void visitAfterChildren(ConfigurationNode node) {
                node.setValue(HierarchicalConfiguration.this.interpolate(node.getValue()));
            }
        });
        return c;
    }

    protected List<ConfigurationNode> fetchNodeList(String key) {
        return this.getExpressionEngine().query(this.getRootNode(), key);
    }

    @Deprecated
    protected void findPropertyNodes(ConfigurationKey.KeyIterator keyPart, Node node, Collection<ConfigurationNode> nodes) {
    }

    @Deprecated
    protected boolean nodeDefined(Node node) {
        return this.nodeDefined((ConfigurationNode)node);
    }

    protected boolean nodeDefined(ConfigurationNode node) {
        DefinedVisitor visitor = new DefinedVisitor();
        node.visit(visitor);
        return visitor.isDefined();
    }

    @Deprecated
    protected void removeNode(Node node) {
        this.removeNode((ConfigurationNode)node);
    }

    protected void removeNode(ConfigurationNode node) {
        ConfigurationNode parent = node.getParentNode();
        if (parent != null) {
            parent.removeChild(node);
            if (!this.nodeDefined(parent)) {
                this.removeNode(parent);
            }
        }
    }

    @Deprecated
    protected void clearNode(Node node) {
        this.clearNode((ConfigurationNode)node);
    }

    protected void clearNode(ConfigurationNode node) {
        node.setValue(null);
        if (!this.nodeDefined(node)) {
            this.removeNode(node);
        }
    }

    @Deprecated
    protected Node fetchAddNode(ConfigurationKey.KeyIterator keyIt, Node startNode) {
        return null;
    }

    @Deprecated
    protected Node findLastPathNode(ConfigurationKey.KeyIterator keyIt, Node node) {
        return null;
    }

    @Deprecated
    protected Node createAddPath(ConfigurationKey.KeyIterator keyIt, Node root) {
        return null;
    }

    protected Node createNode(String name) {
        return new Node(name);
    }

    private ConfigurationNode processNodeAddData(NodeAddData data) {
        ConfigurationNode node = data.getParent();
        for (String name : data.getPathNodes()) {
            Node child = this.createNode(name);
            node.addChild(child);
            node = child;
        }
        Node child = this.createNode(data.getNewNodeName());
        if (data.isAttribute()) {
            node.addAttribute(child);
        } else {
            node.addChild(child);
        }
        return child;
    }

    protected static void clearReferences(ConfigurationNode node) {
        node.visit(new ConfigurationNodeVisitorAdapter(){

            public void visitBeforeChildren(ConfigurationNode node) {
                node.setReference(null);
            }
        });
    }

    private static Node getNodeFor(Object obj) {
        Node nd;
        if (obj instanceof ViewNode) {
            final ViewNode viewNode = (ViewNode)obj;
            nd = new Node(viewNode){

                public void setReference(Object reference) {
                    super.setReference(reference);
                    viewNode.setReference(reference);
                }
            };
        } else {
            nd = (Node)obj;
        }
        return nd;
    }

    protected static abstract class BuilderVisitor
    extends NodeVisitor {
        protected BuilderVisitor() {
        }

        public void visitBeforeChildren(Node node, ConfigurationKey key) {
            LinkedList<ConfigurationNode> subNodes = new LinkedList<ConfigurationNode>(node.getChildren());
            subNodes.addAll(node.getAttributes());
            Iterator children = subNodes.iterator();
            Node sibling1 = null;
            Node nd = null;
            while (children.hasNext()) {
                Object obj;
                Object obj2;
                do {
                    sibling1 = nd;
                } while ((nd = HierarchicalConfiguration.getNodeFor(obj2 = children.next())).getReference() != null && children.hasNext());
                if (nd.getReference() != null) continue;
                LinkedList<Node> newNodes = new LinkedList<Node>();
                newNodes.add(nd);
                while (children.hasNext() && (nd = HierarchicalConfiguration.getNodeFor(obj = children.next())).getReference() == null) {
                    newNodes.add(nd);
                }
                Node sibling2 = nd.getReference() == null ? null : nd;
                for (Node insertNode : newNodes) {
                    if (insertNode.getReference() != null) continue;
                    Object ref = this.insert(insertNode, node, sibling1, sibling2);
                    if (ref != null) {
                        insertNode.setReference(ref);
                    }
                    sibling1 = insertNode;
                }
            }
        }

        protected abstract Object insert(Node var1, Node var2, Node var3, Node var4);
    }

    static class CloneVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Stack<ConfigurationNode> copyStack = new Stack();
        private ConfigurationNode result;

        public void visitAfterChildren(ConfigurationNode node) {
            ConfigurationNode copy = this.copyStack.pop();
            if (this.copyStack.isEmpty()) {
                this.result = copy;
            }
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            ConfigurationNode copy = (ConfigurationNode)node.clone();
            copy.setParentNode(null);
            if (!this.copyStack.isEmpty()) {
                if (node.isAttribute()) {
                    this.copyStack.peek().addAttribute(copy);
                } else {
                    this.copyStack.peek().addChild(copy);
                }
            }
            this.copyStack.push(copy);
        }

        public ConfigurationNode getClone() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefinedKeysVisitor
    extends ConfigurationNodeVisitorAdapter {
        private Set<String> keyList = new LinkedHashSet<String>();
        private Stack<String> parentKeys = new Stack();

        public DefinedKeysVisitor() {
        }

        public DefinedKeysVisitor(String prefix) {
            this();
            this.parentKeys.push(prefix);
        }

        public Set<String> getKeyList() {
            return this.keyList;
        }

        @Override
        public void visitAfterChildren(ConfigurationNode node) {
            this.parentKeys.pop();
        }

        @Override
        public void visitBeforeChildren(ConfigurationNode node) {
            String parentKey = this.parentKeys.isEmpty() ? null : this.parentKeys.peek();
            String key = HierarchicalConfiguration.this.getExpressionEngine().nodeKey(node, parentKey);
            this.parentKeys.push(key);
            if (node.getValue() != null) {
                this.keyList.add(key);
            }
        }
    }

    static class DefinedVisitor
    extends ConfigurationNodeVisitorAdapter {
        private boolean defined;

        DefinedVisitor() {
        }

        public boolean terminate() {
            return this.isDefined();
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            this.defined = node.getValue() != null;
        }

        public boolean isDefined() {
            return this.defined;
        }
    }

    public static class NodeVisitor {
        public void visitBeforeChildren(Node node, ConfigurationKey key) {
        }

        public void visitAfterChildren(Node node, ConfigurationKey key) {
        }

        public boolean terminate() {
            return false;
        }
    }

    public static class Node
    extends DefaultConfigurationNode
    implements Serializable {
        private static final long serialVersionUID = -6357500633536941775L;

        public Node() {
        }

        public Node(String name) {
            super(name);
        }

        public Node(String name, Object value) {
            super(name, value);
        }

        public Node(ConfigurationNode src) {
            this(src.getName(), src.getValue());
            ConfigurationNode parent;
            this.setReference(src.getReference());
            for (ConfigurationNode nd : src.getChildren()) {
                parent = nd.getParentNode();
                this.addChild(nd);
                nd.setParentNode(parent);
            }
            for (ConfigurationNode nd : src.getAttributes()) {
                parent = nd.getParentNode();
                this.addAttribute(nd);
                nd.setParentNode(parent);
            }
        }

        public Node getParent() {
            return (Node)this.getParentNode();
        }

        public void setParent(Node node) {
            this.setParentNode(node);
        }

        public void addChild(Node node) {
            this.addChild((ConfigurationNode)node);
        }

        public boolean hasChildren() {
            return this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
        }

        public boolean remove(Node child) {
            return child.isAttribute() ? this.removeAttribute(child) : this.removeChild(child);
        }

        public boolean remove(String name) {
            boolean childrenRemoved = this.removeChild(name);
            boolean attrsRemoved = this.removeAttribute(name);
            return childrenRemoved || attrsRemoved;
        }

        public void visit(NodeVisitor visitor, ConfigurationKey key) {
            ConfigurationNode obj;
            int length = 0;
            if (key != null) {
                length = key.length();
                if (this.getName() != null) {
                    key.append(StringUtils.replace(this.isAttribute() ? ConfigurationKey.constructAttributeKey(this.getName()) : this.getName(), String.valueOf('.'), ConfigurationKey.ESCAPED_DELIMITER));
                }
            }
            visitor.visitBeforeChildren(this, key);
            Iterator<ConfigurationNode> it = this.getChildren().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                obj = it.next();
                HierarchicalConfiguration.getNodeFor(obj).visit(visitor, key);
            }
            it = this.getAttributes().iterator();
            while (it.hasNext() && !visitor.terminate()) {
                obj = it.next();
                HierarchicalConfiguration.getNodeFor(obj).visit(visitor, key);
            }
            visitor.visitAfterChildren(this, key);
            if (key != null) {
                key.setLength(length);
            }
        }
    }
}

