/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.apache.bookkeeper.common.util.affinity.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.pulsar.v3_0_8.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.lang3.StringUtils;

class ProcessorsInfo {
    private static final Charset ENCODING = StandardCharsets.US_ASCII;
    private final Map<Integer, Integer> cpus = new TreeMap<Integer, Integer>();

    ProcessorsInfo() {
    }

    public Set<Integer> getCpusOnSameCore(int targetCpu) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        int targetCore = this.cpus.get(targetCpu);
        this.cpus.forEach((cpu, core) -> {
            if (core == targetCore) {
                result.add((Integer)cpu);
            }
        });
        return result;
    }

    static ProcessorsInfo parseCpuInfo(String cpuInfoString) {
        ProcessorsInfo pi = new ProcessorsInfo();
        for (String cpu : cpuInfoString.split("\n\n")) {
            int cpuId = -1;
            int coreId = -1;
            for (String line : cpu.split("\n")) {
                String[] parts = line.split(":", 2);
                String key = StringUtils.trim(parts[0]);
                String value = StringUtils.trim(parts[1]);
                if (key.equals("core id")) {
                    coreId = Integer.parseInt(value);
                    continue;
                }
                if (!key.equals("processor")) continue;
                cpuId = Integer.parseInt(value);
            }
            Preconditions.checkArgument(cpuId >= 0);
            Preconditions.checkArgument(coreId >= 0);
            pi.cpus.put(cpuId, coreId);
        }
        return pi;
    }

    static ProcessorsInfo parseCpuInfo() {
        try {
            return ProcessorsInfo.parseCpuInfo(new String(Files.readAllBytes(Paths.get("/proc/cpuinfo", new String[0])), ENCODING));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

