/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.apache.bookkeeper.common.util.affinity.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.NonNull;

public final class NativeUtils {
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="work around for java 9: https://github.com/spotbugs/spotbugs/issues/493")
    public static void loadLibraryFromJar(String path) throws Exception {
        NativeUtils.checkArgument(path.startsWith("/"), "absolute path must start with /");
        String[] parts = path.split("/");
        NativeUtils.checkArgument(parts.length > 0, "absolute path must contain file name");
        String filename = parts[parts.length - 1];
        NativeUtils.checkArgument(path.startsWith("/"), "absolute path must start with /");
        Path dir = Files.createTempDirectory("native", new FileAttribute[0]);
        dir.toFile().deleteOnExit();
        File temp = new File(dir.toString(), filename);
        temp.deleteOnExit();
        byte[] buffer = new byte[1024];
        try (InputStream input = NativeUtils.class.getResourceAsStream(path);
             FileOutputStream out = new FileOutputStream(temp);){
            int read;
            if (input == null) {
                throw new FileNotFoundException("Couldn't find file into jar " + path);
            }
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        if (!temp.exists()) {
            throw new FileNotFoundException("Failed to copy file from jar at " + temp.getAbsolutePath());
        }
        System.load(temp.getAbsolutePath());
    }

    private static void checkArgument(boolean expression, @NonNull Object errorMessage) {
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    private NativeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

