/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.io.netty.handler.codec.compression;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.v3_0_8.shade.io.netty.channel.ChannelFuture;
import org.apache.pulsar.v3_0_8.shade.io.netty.channel.ChannelFutureListener;
import org.apache.pulsar.v3_0_8.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.v3_0_8.shade.io.netty.channel.ChannelPromise;
import org.apache.pulsar.v3_0_8.shade.io.netty.util.concurrent.ScheduledFuture;

final class EncoderUtil {
    private static final int THREAD_POOL_DELAY_SECONDS = 10;

    static void closeAfterFinishEncode(final ChannelHandlerContext ctx, ChannelFuture finishFuture, final ChannelPromise promise) {
        if (!finishFuture.isDone()) {
            final ScheduledFuture<?> future = ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    ctx.close(promise);
                }
            }, 10L, TimeUnit.SECONDS);
            finishFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture f) {
                    future.cancel(true);
                    if (!promise.isDone()) {
                        ctx.close(promise);
                    }
                }
            });
        } else {
            ctx.close(promise);
        }
    }

    private EncoderUtil() {
    }
}

