/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd;

import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.BlockCompressionState;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.BlockCompressor;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.CompressionParameters;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.RepeatedOffsets;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.SequenceStore;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.zstd.UnsafeUtil;

class DoubleFastBlockCompressor
implements BlockCompressor {
    private static final int MIN_MATCH = 3;
    private static final int SEARCH_STRENGTH = 8;
    private static final int REP_MOVE = 2;
    private static final int PRIME_4_BYTES = -1640531535;
    private static final long PRIME_5_BYTES = 889523592379L;
    private static final long PRIME_6_BYTES = 227718039650203L;
    private static final long PRIME_7_BYTES = 58295818150454627L;
    private static final long PRIME_8_BYTES = -3523014627327384477L;

    DoubleFastBlockCompressor() {
    }

    @Override
    public int compressBlock(Object inputBase, long inputAddress, int inputSize, SequenceStore output, BlockCompressionState state, RepeatedOffsets offsets, CompressionParameters parameters) {
        int maxRep;
        int matchSearchLength = Math.max(parameters.getSearchLength(), 4);
        long baseAddress = state.getBaseAddress();
        long windowBaseAddress = baseAddress + (long)state.getWindowBaseOffset();
        int[] longHashTable = state.hashTable;
        int longHashBits = parameters.getHashLog();
        int[] shortHashTable = state.chainTable;
        int shortHashBits = parameters.getChainLog();
        long inputEnd = inputAddress + (long)inputSize;
        long inputLimit = inputEnd - 8L;
        long input = inputAddress;
        long anchor = inputAddress;
        int offset1 = offsets.getOffset0();
        int offset2 = offsets.getOffset1();
        int savedOffset = 0;
        if (input - windowBaseAddress == 0L) {
            ++input;
        }
        if (offset2 > (maxRep = (int)(input - windowBaseAddress))) {
            savedOffset = offset2;
            offset2 = 0;
        }
        if (offset1 > maxRep) {
            savedOffset = offset1;
            offset1 = 0;
        }
        while (input < inputLimit) {
            int matchLength;
            int current;
            int shortHash = DoubleFastBlockCompressor.hash(inputBase, input, shortHashBits, matchSearchLength);
            long shortMatchAddress = baseAddress + (long)shortHashTable[shortHash];
            int longHash = DoubleFastBlockCompressor.hash8(UnsafeUtil.UNSAFE.getLong(inputBase, input), longHashBits);
            long longMatchAddress = baseAddress + (long)longHashTable[longHash];
            longHashTable[longHash] = current = (int)(input - baseAddress);
            shortHashTable[shortHash] = current;
            if (offset1 > 0 && UnsafeUtil.UNSAFE.getInt(inputBase, input + 1L - (long)offset1) == UnsafeUtil.UNSAFE.getInt(inputBase, input + 1L)) {
                matchLength = DoubleFastBlockCompressor.count(inputBase, input + 1L + 4L, inputEnd, input + 1L + 4L - (long)offset1) + 4;
                output.storeSequence(inputBase, anchor, (int)(++input - anchor), 0, matchLength - 3);
            } else {
                int offset;
                if (longMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getLong(inputBase, longMatchAddress) == UnsafeUtil.UNSAFE.getLong(inputBase, input)) {
                    matchLength = DoubleFastBlockCompressor.count(inputBase, input + 8L, inputEnd, longMatchAddress + 8L) + 8;
                    offset = (int)(input - longMatchAddress);
                    while (input > anchor && longMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getByte(inputBase, input - 1L) == UnsafeUtil.UNSAFE.getByte(inputBase, longMatchAddress - 1L)) {
                        --input;
                        --longMatchAddress;
                        ++matchLength;
                    }
                } else if (shortMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getInt(inputBase, shortMatchAddress) == UnsafeUtil.UNSAFE.getInt(inputBase, input)) {
                    int nextOffsetHash = DoubleFastBlockCompressor.hash8(UnsafeUtil.UNSAFE.getLong(inputBase, input + 1L), longHashBits);
                    long nextOffsetMatchAddress = baseAddress + (long)longHashTable[nextOffsetHash];
                    longHashTable[nextOffsetHash] = current + 1;
                    if (nextOffsetMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getLong(inputBase, nextOffsetMatchAddress) == UnsafeUtil.UNSAFE.getLong(inputBase, input + 1L)) {
                        matchLength = DoubleFastBlockCompressor.count(inputBase, input + 1L + 8L, inputEnd, nextOffsetMatchAddress + 8L) + 8;
                        offset = (int)(++input - nextOffsetMatchAddress);
                        while (input > anchor && nextOffsetMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getByte(inputBase, input - 1L) == UnsafeUtil.UNSAFE.getByte(inputBase, nextOffsetMatchAddress - 1L)) {
                            --input;
                            --nextOffsetMatchAddress;
                            ++matchLength;
                        }
                    } else {
                        matchLength = DoubleFastBlockCompressor.count(inputBase, input + 4L, inputEnd, shortMatchAddress + 4L) + 4;
                        offset = (int)(input - shortMatchAddress);
                        while (input > anchor && shortMatchAddress > windowBaseAddress && UnsafeUtil.UNSAFE.getByte(inputBase, input - 1L) == UnsafeUtil.UNSAFE.getByte(inputBase, shortMatchAddress - 1L)) {
                            --input;
                            --shortMatchAddress;
                            ++matchLength;
                        }
                    }
                } else {
                    input += (input - anchor >> 8) + 1L;
                    continue;
                }
                offset2 = offset1;
                offset1 = offset;
                output.storeSequence(inputBase, anchor, (int)(input - anchor), offset + 2, matchLength - 3);
            }
            anchor = input += (long)matchLength;
            if (input > inputLimit) continue;
            longHashTable[DoubleFastBlockCompressor.hash8((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)(baseAddress + (long)current + 2L)), (int)longHashBits)] = current + 2;
            shortHashTable[DoubleFastBlockCompressor.hash((Object)inputBase, (long)(baseAddress + (long)current + 2L), (int)shortHashBits, (int)matchSearchLength)] = current + 2;
            longHashTable[DoubleFastBlockCompressor.hash8((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)(input - 2L)), (int)longHashBits)] = (int)(input - 2L - baseAddress);
            shortHashTable[DoubleFastBlockCompressor.hash((Object)inputBase, (long)(input - 2L), (int)shortHashBits, (int)matchSearchLength)] = (int)(input - 2L - baseAddress);
            while (input <= inputLimit && offset2 > 0 && UnsafeUtil.UNSAFE.getInt(inputBase, input) == UnsafeUtil.UNSAFE.getInt(inputBase, input - (long)offset2)) {
                int repetitionLength = DoubleFastBlockCompressor.count(inputBase, input + 4L, inputEnd, input + 4L - (long)offset2) + 4;
                int temp = offset2;
                offset2 = offset1;
                offset1 = temp;
                shortHashTable[DoubleFastBlockCompressor.hash((Object)inputBase, (long)input, (int)shortHashBits, (int)matchSearchLength)] = (int)(input - baseAddress);
                longHashTable[DoubleFastBlockCompressor.hash8((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)input), (int)longHashBits)] = (int)(input - baseAddress);
                output.storeSequence(inputBase, anchor, 0, 0, repetitionLength - 3);
                anchor = input += (long)repetitionLength;
            }
        }
        offsets.saveOffset0(offset1 != 0 ? offset1 : savedOffset);
        offsets.saveOffset1(offset2 != 0 ? offset2 : savedOffset);
        return (int)(inputEnd - anchor);
    }

    public static int count(Object inputBase, long inputAddress, long inputLimit, long matchAddress) {
        long input = inputAddress;
        long match = matchAddress;
        int remaining = (int)(inputLimit - inputAddress);
        int count = 0;
        while (count < remaining - 7) {
            long diff = UnsafeUtil.UNSAFE.getLong(inputBase, match) ^ UnsafeUtil.UNSAFE.getLong(inputBase, input);
            if (diff != 0L) {
                return count + (Long.numberOfTrailingZeros(diff) >> 3);
            }
            count += 8;
            input += 8L;
            match += 8L;
        }
        while (count < remaining && UnsafeUtil.UNSAFE.getByte(inputBase, match) == UnsafeUtil.UNSAFE.getByte(inputBase, input)) {
            ++count;
            ++input;
            ++match;
        }
        return count;
    }

    private static int hash(Object inputBase, long inputAddress, int bits, int matchSearchLength) {
        switch (matchSearchLength) {
            case 8: {
                return DoubleFastBlockCompressor.hash8(UnsafeUtil.UNSAFE.getLong(inputBase, inputAddress), bits);
            }
            case 7: {
                return DoubleFastBlockCompressor.hash7(UnsafeUtil.UNSAFE.getLong(inputBase, inputAddress), bits);
            }
            case 6: {
                return DoubleFastBlockCompressor.hash6(UnsafeUtil.UNSAFE.getLong(inputBase, inputAddress), bits);
            }
            case 5: {
                return DoubleFastBlockCompressor.hash5(UnsafeUtil.UNSAFE.getLong(inputBase, inputAddress), bits);
            }
        }
        return DoubleFastBlockCompressor.hash4(UnsafeUtil.UNSAFE.getInt(inputBase, inputAddress), bits);
    }

    private static int hash4(int value, int bits) {
        return value * -1640531535 >>> 32 - bits;
    }

    private static int hash5(long value, int bits) {
        return (int)((value << 24) * 889523592379L >>> 64 - bits);
    }

    private static int hash6(long value, int bits) {
        return (int)((value << 16) * 227718039650203L >>> 64 - bits);
    }

    private static int hash7(long value, int bits) {
        return (int)((value << 8) * 58295818150454627L >>> 64 - bits);
    }

    private static int hash8(long value, int bits) {
        return (int)(value * -3523014627327384477L >>> 64 - bits);
    }
}

