/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;

final class DirectArrayOfDoublesSketchIterator
implements ArrayOfDoublesSketchIterator {
    private Memory mem_;
    private int offset_;
    private int numEntries_;
    private int numValues_;
    private int i_;
    private static final int SIZE_OF_KEY_BYTES = 8;
    private static final int SIZE_OF_VALUE_BYTES = 8;

    DirectArrayOfDoublesSketchIterator(Memory mem, int offset, int numEntries, int numValues) {
        this.mem_ = mem;
        this.offset_ = offset;
        this.numEntries_ = numEntries;
        this.numValues_ = numValues;
        this.i_ = -1;
    }

    @Override
    public boolean next() {
        ++this.i_;
        while (this.i_ < this.numEntries_) {
            if (this.mem_.getLong(this.offset_ + 8 * this.i_) != 0L) {
                return true;
            }
            ++this.i_;
        }
        return false;
    }

    @Override
    public long getKey() {
        return this.mem_.getLong(this.offset_ + 8 * this.i_);
    }

    @Override
    public double[] getValues() {
        if (this.numValues_ == 1) {
            return new double[]{this.mem_.getDouble(this.offset_ + 8 * this.numEntries_ + 8 * this.i_)};
        }
        double[] array = new double[this.numValues_];
        this.mem_.getDoubleArray(this.offset_ + 8 * this.numEntries_ + 8 * this.i_ * this.numValues_, array, 0, this.numValues_);
        return array;
    }
}

