/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple;

import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.DeserializeResult;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.SerializerDeserializer;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.Sketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.Summary;

public class CompactSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionUID = 1;

    CompactSketch(long[] keys, S[] summaries, long theta, boolean isEmpty) {
        this.keys_ = keys;
        this.summaries_ = summaries;
        this.theta_ = theta;
        this.isEmpty_ = isEmpty;
    }

    CompactSketch(Memory mem) {
        boolean hasEntries;
        boolean isThetaIncluded;
        boolean isBigEndian;
        int offset = 0;
        byte preambleLongs = mem.getByte(offset++);
        byte version = mem.getByte(offset++);
        byte familyId = mem.getByte(offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        SerializerDeserializer.validateType(mem.getByte(offset++), SerializerDeserializer.SketchType.CompactSketch);
        byte flags = mem.getByte(offset++);
        boolean bl = isBigEndian = (flags & 1 << Flags.IS_BIG_ENDIAN.ordinal()) > 0;
        if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            throw new SketchesArgumentException("Byte order mismatch");
        }
        this.isEmpty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
        boolean bl2 = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
        if (isThetaIncluded) {
            this.theta_ = mem.getLong(offset);
            offset += 8;
        } else {
            this.theta_ = Long.MAX_VALUE;
        }
        boolean bl3 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
        if (hasEntries) {
            int i;
            byte classNameLength = mem.getByte(offset++);
            int count = mem.getInt(offset);
            byte[] classNameBuffer = new byte[classNameLength];
            mem.getByteArray(offset += 4, classNameBuffer, 0, classNameLength);
            offset += classNameLength;
            String className = new String(classNameBuffer, StandardCharsets.UTF_8);
            this.keys_ = new long[count];
            for (i = 0; i < count; ++i) {
                this.keys_[i] = mem.getLong(offset);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                DeserializeResult result = SerializerDeserializer.deserializeFromMemory(mem, offset, className);
                Summary summary = (Summary)result.getObject();
                offset += result.getSize();
                if (this.summaries_ == null) {
                    this.summaries_ = (Summary[])Array.newInstance(summary.getClass(), count);
                }
                this.summaries_[i] = summary;
            }
        }
    }

    @Override
    public S[] getSummaries() {
        if (this.keys_ == null || this.keys_.length == 0) {
            return null;
        }
        Summary[] summaries = (Summary[])Array.newInstance(this.summaries_.getClass().getComponentType(), this.summaries_.length);
        for (int i = 0; i < this.summaries_.length; ++i) {
            summaries[i] = this.summaries_[i].copy();
        }
        return summaries;
    }

    @Override
    public int getRetainedEntries() {
        return this.keys_ == null ? 0 : this.keys_.length;
    }

    @Override
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        int summariesBytesLength = 0;
        Object summariesBytes = null;
        int count = this.getRetainedEntries();
        if (count > 0) {
            summariesBytes = new byte[count][];
            for (int i = 0; i < count; ++i) {
                summariesBytes[i] = this.summaries_[i].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
            }
        }
        int sizeBytes = 5;
        boolean bl = isThetaIncluded = this.theta_ < Long.MAX_VALUE;
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        String summaryClassName = null;
        if (count > 0) {
            summaryClassName = this.summaries_[0].getClass().getName();
            sizeBytes += 5 + summaryClassName.length() + 8 * count + summariesBytesLength;
        }
        byte[] bytes = new byte[sizeBytes];
        NativeMemory mem = new NativeMemory(bytes);
        int offset = 0;
        mem.putByte(offset++, (byte)1);
        mem.putByte(offset++, (byte)1);
        mem.putByte(offset++, (byte)Family.TUPLE.getID());
        mem.putByte(offset++, (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal());
        boolean isBigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        mem.putByte(offset++, (byte)((isBigEndian ? 1 << Flags.IS_BIG_ENDIAN.ordinal() : 0) | (this.isEmpty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (count > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0)));
        if (isThetaIncluded) {
            mem.putLong(offset, this.theta_);
            offset += 8;
        }
        if (count > 0) {
            int i;
            mem.putByte(offset++, (byte)summaryClassName.length());
            mem.putInt(offset, this.getRetainedEntries());
            mem.putByteArray(offset += 4, summaryClassName.getBytes(StandardCharsets.UTF_8), 0, summaryClassName.length());
            offset += summaryClassName.length();
            for (i = 0; i < count; ++i) {
                mem.putLong(offset, this.keys_[i]);
                offset += 8;
            }
            for (i = 0; i < count; ++i) {
                mem.putByteArray(offset, summariesBytes[i], 0, summariesBytes[i].length);
                offset += summariesBytes[i].length;
            }
        }
        return bytes;
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

