/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple;

import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesStateException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesCombiner;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesQuickSelectSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesIntersection {
    final int numValues_;
    final long seed_;
    final short seedHash_;
    ArrayOfDoublesQuickSelectSketch sketch_;
    boolean isEmpty_;
    long theta_;
    boolean isFirstCall_;

    ArrayOfDoublesIntersection(int numValues, long seed) {
        this.numValues_ = numValues;
        this.seed_ = seed;
        this.seedHash_ = Util.computeSeedHash(seed);
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.isFirstCall_ = true;
    }

    public void update(ArrayOfDoublesSketch sketchIn, ArrayOfDoublesCombiner combiner) {
        boolean isFirstCall = this.isFirstCall_;
        this.isFirstCall_ = false;
        if (sketchIn == null) {
            this.isEmpty_ = true;
            this.sketch_ = null;
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        this.theta_ = Math.min(this.theta_, sketchIn.getThetaLong());
        this.isEmpty_ |= sketchIn.isEmpty();
        if (this.isEmpty_ || sketchIn.getRetainedEntries() == 0) {
            this.sketch_ = null;
            return;
        }
        if (isFirstCall) {
            this.sketch_ = this.createSketch(sketchIn.getRetainedEntries(), this.numValues_, this.seed_);
            ArrayOfDoublesSketchIterator it = sketchIn.iterator();
            while (it.next()) {
                this.sketch_.insert(it.getKey(), it.getValues());
            }
        } else {
            int matchSize = Math.min(this.sketch_.getRetainedEntries(), sketchIn.getRetainedEntries());
            long[] matchKeys = new long[matchSize];
            double[][] matchValues = new double[matchSize][];
            int matchCount = 0;
            ArrayOfDoublesSketchIterator it = sketchIn.iterator();
            while (it.next()) {
                double[] values = this.sketch_.find(it.getKey());
                if (values == null) continue;
                matchKeys[matchCount] = it.getKey();
                matchValues[matchCount] = combiner.combine(values, it.getValues());
                ++matchCount;
            }
            this.sketch_ = null;
            if (matchCount > 0) {
                this.sketch_ = this.createSketch(matchCount, this.numValues_, this.seed_);
                for (int i = 0; i < matchCount; ++i) {
                    this.sketch_.insert(matchKeys[i], matchValues[i]);
                }
            }
            if (this.sketch_ != null) {
                this.sketch_.setThetaLong(this.theta_);
                this.sketch_.setNotEmpty();
            }
        }
    }

    public ArrayOfDoublesCompactSketch getResult(Memory dstMem) {
        if (this.isFirstCall_) {
            throw new SketchesStateException("getResult() with no intervening intersections is not a legal result.");
        }
        if (this.sketch_ == null) {
            return new HeapArrayOfDoublesCompactSketch(null, null, Long.MAX_VALUE, true, this.numValues_, this.seedHash_);
        }
        return this.sketch_.compact(dstMem);
    }

    public ArrayOfDoublesCompactSketch getResult() {
        return this.getResult(null);
    }

    public void reset() {
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.sketch_ = null;
        this.isFirstCall_ = true;
    }

    abstract ArrayOfDoublesQuickSelectSketch createSketch(int var1, int var2, long var3);
}

