/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.theta;

import java.nio.ByteOrder;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.ResizeFactor;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Util;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int LG_RESIZE_FACTOR_BITS = 6;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int LG_NOM_LONGS_BYTE = 3;
    static final int LG_ARR_LONGS_BYTE = 4;
    static final int FLAGS_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int RETAINED_ENTRIES_INT = 8;
    static final int P_FLOAT = 12;
    static final int THETA_LONG = 16;
    static final int UNION_THETA_LONG = 24;
    static final int BIG_ENDIAN_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final int LG_RESIZE_RATIO_BYTE_V1 = 5;
    static final int FLAGS_BYTE_V1 = 6;
    static final int SER_VER = 3;
    static final boolean NATIVE_ORDER_IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final double MAX_THETA_LONG_AS_DOUBLE = 9.223372036854776E18;

    private PreambleUtil() {
    }

    static final int getMemBytes(int lgArrLongs, int preambleLongs) {
        return (8 << lgArrLongs) + (preambleLongs << 3);
    }

    public static String preambleToString(byte[] byteArr) {
        NativeMemory mem = new NativeMemory(byteArr);
        return PreambleUtil.preambleToString(mem);
    }

    public static String preambleToString(Memory mem) {
        long pre1;
        long thetaLong;
        int preLongs = PreambleUtil.getAndCheckPreLongs(mem);
        long pre0 = mem.getLong(0L);
        ResizeFactor rf = ResizeFactor.getRF(PreambleUtil.extractResizeFactor(pre0));
        int serVer = PreambleUtil.extractSerVer(pre0);
        Family family = Family.idToFamily(PreambleUtil.extractFamilyID(pre0));
        int lgNomLongs = PreambleUtil.extractLgNomLongs(pre0);
        int lgArrLongs = PreambleUtil.extractLgArrLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean bigEndian = (flags & 1) > 0;
        String nativeOrder = ByteOrder.nativeOrder().toString();
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        int seedHash = PreambleUtil.extractSeedHash(pre0);
        int curCount = 0;
        float p = 1.0f;
        long thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        if (preLongs == 2) {
            pre1 = mem.getLong(8L);
            curCount = PreambleUtil.extractCurCount(pre1);
            p = PreambleUtil.extractP(pre1);
            thetaULong = thetaLong = (long)((double)p * 9.223372036854776E18);
        } else if (preLongs == 3) {
            pre1 = mem.getLong(8L);
            curCount = PreambleUtil.extractCurCount(pre1);
            p = PreambleUtil.extractP(pre1);
            thetaULong = thetaLong = mem.getLong(16L);
        } else if (preLongs == 4) {
            pre1 = mem.getLong(8L);
            curCount = PreambleUtil.extractCurCount(pre1);
            p = PreambleUtil.extractP(pre1);
            thetaLong = mem.getLong(16L);
            thetaULong = mem.getLong(24L);
        }
        double thetaDbl = (double)thetaLong / 9.223372036854776E18;
        String thetaHex = Util.zeroPad(Long.toHexString(thetaLong), 16);
        double thetaUDbl = (double)thetaULong / 9.223372036854776E18;
        String thetaUHex = Util.zeroPad(Long.toHexString(thetaULong), 16);
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### SKETCH PREAMBLE SUMMARY:").append(Util.LS).append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS).append("Byte  0: ResizeFactor         : ").append(rf.toString()).append(Util.LS).append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS).append("Byte  2: Family               : ").append(family.toString()).append(Util.LS).append("Byte  3: LgNomLongs           : ").append(lgNomLongs).append(Util.LS).append("Byte  4: LgArrLongs           : ").append(lgArrLongs).append(Util.LS).append("Byte  5: Flags Field          : ").append(flagsStr).append(Util.LS).append("  BIG_ENDIAN_STORAGE          : ").append(bigEndian).append(Util.LS).append("  (Native Byte Order)         : ").append(nativeOrder).append(Util.LS).append("  READ_ONLY                   : ").append(readOnly).append(Util.LS).append("  EMPTY                       : ").append(empty).append(Util.LS).append("  COMPACT                     : ").append(compact).append(Util.LS).append("  ORDERED                     : ").append(ordered).append(Util.LS).append("Bytes 6-7  : Seed Hash        : ").append(Integer.toHexString(seedHash)).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 2) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 3) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
        }
        if (preLongs == 4) {
            sb.append("Bytes 8-11 : CurrentCount     : ").append(curCount).append(Util.LS).append("Bytes 12-15: P                : ").append(p).append(Util.LS);
            sb.append("Bytes 16-23: Theta (double)   : ").append(thetaDbl).append(Util.LS).append("             Theta (long)     : ").append(thetaLong).append(Util.LS).append("             Theta (long,hex) : ").append(thetaHex).append(Util.LS);
            sb.append("Bytes 25-31: ThetaU (double)  : ").append(thetaUDbl).append(Util.LS).append("             ThetaU (long)    : ").append(thetaULong).append(Util.LS).append("             ThetaU (long,hex): ").append(thetaUHex).append(Util.LS);
        }
        sb.append("Preamble Bytes                : ").append(preLongs * 8).append(Util.LS);
        sb.append("Data Bytes                    : ").append(curCount * 8).append(Util.LS);
        sb.append("TOTAL Sketch Bytes            : ").append(mem.getCapacity()).append(Util.LS).append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(long long0) {
        long mask = 63L;
        return (int)(long0 & 0x3FL);
    }

    static int extractResizeFactor(long long0) {
        int shift = 6;
        long mask = 3L;
        return (int)(long0 >>> 6 & 3L);
    }

    static int extractSerVer(long long0) {
        int shift = 8;
        long mask = 255L;
        return (int)(long0 >>> 8 & 0xFFL);
    }

    static int extractFamilyID(long long0) {
        int shift = 16;
        long mask = 255L;
        return (int)(long0 >>> 16 & 0xFFL);
    }

    static int extractLgNomLongs(long long0) {
        int shift = 24;
        long mask = 255L;
        return (int)(long0 >>> 24 & 0xFFL);
    }

    static int extractLgArrLongs(long long0) {
        int shift = 32;
        long mask = 255L;
        return (int)(long0 >>> 32 & 0xFFL);
    }

    static int extractFlags(long long0) {
        int shift = 40;
        long mask = 255L;
        return (int)(long0 >>> 40 & 0xFFL);
    }

    static int extractFlagsV1(long long0) {
        int shift = 48;
        long mask = 255L;
        return (int)(long0 >>> 48 & 0xFFL);
    }

    static int extractSeedHash(long long0) {
        int shift = 48;
        long mask = 65535L;
        return (int)(long0 >>> 48 & 0xFFFFL);
    }

    static int extractCurCount(long long1) {
        long mask = 0xFFFFFFFFL;
        return (int)(long1 & 0xFFFFFFFFL);
    }

    static float extractP(long long1) {
        int shift = 32;
        return Float.intBitsToFloat((int)(long1 >>> 32));
    }

    static long insertPreLongs(int preLongs, long long0) {
        long mask = 63L;
        return (long)preLongs & 0x3FL | 0xFFFFFFFFFFFFFFC0L & long0;
    }

    static long insertResizeFactor(int rf, long long0) {
        int shift = 6;
        long mask = 3L;
        return ((long)rf & 3L) << 6 | 0xFFFFFFFFFFFFFF3FL & long0;
    }

    static long insertSerVer(int serVer, long long0) {
        int shift = 8;
        long mask = 255L;
        return ((long)serVer & 0xFFL) << 8 | 0xFFFFFFFFFFFF00FFL & long0;
    }

    static long insertFamilyID(int familyID, long long0) {
        int shift = 16;
        long mask = 255L;
        return ((long)familyID & 0xFFL) << 16 | 0xFFFFFFFFFF00FFFFL & long0;
    }

    static long insertLgNomLongs(int lgNomLongs, long long0) {
        int shift = 24;
        long mask = 255L;
        return ((long)lgNomLongs & 0xFFL) << 24 | 0xFFFFFFFF00FFFFFFL & long0;
    }

    static long insertLgArrLongs(int lgArrLongs, long long0) {
        int shift = 32;
        long mask = 255L;
        return ((long)lgArrLongs & 0xFFL) << 32 | 0xFFFFFF00FFFFFFFFL & long0;
    }

    static long insertFlags(int flags, long long0) {
        int shift = 40;
        long mask = 255L;
        return ((long)flags & 0xFFL) << 40 | 0xFFFF00FFFFFFFFFFL & long0;
    }

    static long insertSeedHash(int seedHash, long long0) {
        int shift = 48;
        long mask = 65535L;
        return ((long)seedHash & 0xFFFFL) << 48 | 0xFFFFFFFFFFFFL & long0;
    }

    static long insertCurCount(int curCount, long long1) {
        long mask = 0xFFFFFFFFL;
        return (long)curCount & 0xFFFFFFFFL | 0xFFFFFFFF00000000L & long1;
    }

    static long insertP(float p, long long1) {
        int shift = 32;
        long mask = 0xFFFFFFFFL;
        return ((long)Float.floatToRawIntBits(p) & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL & long1;
    }

    static int getAndCheckPreLongs(Memory mem) {
        long pre0;
        int preLongs;
        int required;
        long cap = mem.getCapacity();
        if (cap < 8L) {
            PreambleUtil.throwNotBigEnough(cap, 8);
        }
        if (cap < (long)(required = Math.max((preLongs = PreambleUtil.extractPreLongs(pre0 = mem.getLong(0L))) << 3, 8))) {
            PreambleUtil.throwNotBigEnough(cap, required);
        }
        return preLongs;
    }

    private static void throwNotBigEnough(long cap, int required) {
        throw new SketchesArgumentException("Possible Corruption: Size of byte array or Memory not large enough: Size: " + cap + ", Required: " + required);
    }
}

