/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.theta;

import java.util.Arrays;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.theta.CompactSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.theta.HeapCompactOrderedSketch;

public class PairwiseSetOperations {
    public static CompactSketch intersect(CompactSketch skA, CompactSketch skB) {
        short seedHash = PairwiseSetOperations.checkOrderedAndSeedHash(skA, skB);
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        int indexA = 0;
        int indexB = 0;
        int outCount = 0;
        long[] cacheA = skA.getCache();
        long[] cacheB = skB.getCache();
        long[] outCache = new long[Math.min(cacheA.length, cacheB.length)];
        while (indexA < cacheA.length && indexB < cacheB.length) {
            long hashA = cacheA[indexA];
            long hashB = cacheB[indexB];
            if (hashA >= thetaLong || hashB >= thetaLong) break;
            if (hashA == hashB) {
                outCache[outCount++] = hashA;
                ++indexA;
                ++indexB;
                continue;
            }
            if (hashA < hashB) {
                ++indexA;
                continue;
            }
            ++indexB;
        }
        boolean empty = skA.isEmpty() || skB.isEmpty();
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outCount), empty, seedHash, outCount, thetaLong);
    }

    public static CompactSketch aNotB(CompactSketch skA, CompactSketch skB) {
        short seedHash = PairwiseSetOperations.checkOrderedAndSeedHash(skA, skB);
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        int indexA = 0;
        int indexB = 0;
        int outCount = 0;
        long[] cacheA = skA.getCache();
        long[] cacheB = skB.getCache();
        long[] outCache = new long[cacheA.length];
        while (indexA < cacheA.length) {
            long hashB;
            long hashA = cacheA[indexA];
            long l = hashB = indexB >= cacheB.length ? thetaLong : cacheB[indexB];
            if (hashA >= thetaLong) break;
            if (hashA == hashB) {
                ++indexA;
                ++indexB;
                continue;
            }
            if (hashA < hashB) {
                outCache[outCount++] = hashA;
                ++indexA;
                continue;
            }
            ++indexB;
        }
        boolean empty = skA.isEmpty();
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outCount), empty, seedHash, outCount, thetaLong);
    }

    public static CompactSketch union(CompactSketch skA, CompactSketch skB) {
        short seedHash = PairwiseSetOperations.checkOrderedAndSeedHash(skA, skB);
        long thetaLong = Math.min(skA.getThetaLong(), skB.getThetaLong());
        int indexA = 0;
        int indexB = 0;
        int outCount = 0;
        long[] cacheA = skA.getCache();
        long[] cacheB = skB.getCache();
        long[] outCache = new long[cacheA.length + cacheB.length];
        while (indexA < cacheA.length || indexB < cacheB.length) {
            long hashB;
            long hashA = indexA >= cacheA.length ? thetaLong : cacheA[indexA];
            long l = hashB = indexB >= cacheB.length ? thetaLong : cacheB[indexB];
            if (hashA >= thetaLong && hashB >= thetaLong) break;
            if (hashA == hashB) {
                outCache[outCount++] = hashA;
                ++indexA;
                ++indexB;
                continue;
            }
            if (hashA < hashB) {
                outCache[outCount++] = hashA;
                ++indexA;
                continue;
            }
            outCache[outCount++] = hashB;
            ++indexB;
        }
        boolean empty = skA.isEmpty() && skB.isEmpty();
        return new HeapCompactOrderedSketch(Arrays.copyOf(outCache, outCount), empty, seedHash, outCount, thetaLong);
    }

    private static final short checkOrderedAndSeedHash(CompactSketch skA, CompactSketch skB) {
        if (!skA.isOrdered() || !skB.isOrdered()) {
            throw new SketchesArgumentException("Sketch must be ordered, got: " + skA.getClass().getSimpleName() + ", " + skB.getClass().getSimpleName());
        }
        short seedHashA = skA.getSeedHash();
        short seedHashB = skB.getSeedHash();
        Util.checkSeedHashes(seedHashA, seedHashB);
        return seedHashA;
    }
}

