/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.sampling;

import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.MemoryRegion;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.sampling.PreambleUtil;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.sampling.ReservoirSize;

final class VersionConverter {
    VersionConverter() {
    }

    static Memory convertSketch1to2(Memory srcMem) {
        return VersionConverter.perform1to2Changes(srcMem);
    }

    static Memory convertUnion1to2(Memory srcMem) {
        boolean isEmpty;
        Memory converted = VersionConverter.perform1to2Changes(srcMem);
        long pre0 = converted.getLong(0L);
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        boolean bl = isEmpty = (flags & 4) > 0;
        if (!isEmpty) {
            int memCap = (int)converted.getCapacity();
            int preLongBytes = preLongs << 3;
            MemoryRegion sketchMem = new MemoryRegion(converted, preLongBytes, memCap - preLongBytes);
            VersionConverter.convertSketch1to2(sketchMem);
        }
        return converted;
    }

    private static Memory perform1to2Changes(Memory srcMem) {
        int memCap = (int)srcMem.getCapacity();
        Memory converted = srcMem;
        if (srcMem.isReadOnly()) {
            byte[] data = new byte[memCap];
            srcMem.getByteArray(0L, data, 0, memCap);
            converted = new NativeMemory(data);
        }
        long pre0 = converted.getLong(0L);
        short encodedK = PreambleUtil.extractEncodedReservoirSize(pre0);
        int k = ReservoirSize.decodeValue(encodedK);
        pre0 = PreambleUtil.insertReservoirSize(k, pre0);
        pre0 = PreambleUtil.insertSerVer(2, pre0);
        converted.putLong(0L, pre0);
        return converted;
    }
}

