/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Family;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util;

final class DoublesUtil {
    private DoublesUtil() {
    }

    static HeapDoublesSketch copy(DoublesSketch sketch) {
        HeapDoublesSketch qsCopy = HeapDoublesSketch.newInstance(sketch.getK());
        qsCopy.n_ = sketch.getN();
        qsCopy.minValue_ = sketch.getMinValue();
        qsCopy.maxValue_ = sketch.getMaxValue();
        qsCopy.combinedBufferItemCapacity_ = sketch.getCombinedBufferItemCapacity();
        qsCopy.baseBufferCount_ = sketch.getBaseBufferCount();
        qsCopy.bitPattern_ = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        qsCopy.combinedBuffer_ = Arrays.copyOf(combBuf, combBuf.length);
        return qsCopy;
    }

    static void checkMemCapacity(int k, long n, boolean compact, long memCapBytes) {
        int reqBufBytes;
        int metaPre = Family.QUANTILES.getMaxPreLongs() + 2;
        int retainedItems = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeRetainedItems(k, n);
        if (compact) {
            reqBufBytes = metaPre + retainedItems << 3;
        } else {
            int totLevels = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeNumLevelsNeeded(k, n);
            int n2 = reqBufBytes = totLevels == 0 ? metaPre + retainedItems << 3 : metaPre + (2 + totLevels) * k << 3;
        }
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkDoublesSerVer(int serVer) {
        int max = 3;
        int min2 = 2;
        if (serVer > 3 || serVer < 2) {
            throw new SketchesArgumentException("Possible corruption: Unsupported Serialization Version: " + serVer);
        }
    }

    static String toString(boolean sketchSummary, boolean dataDetail, DoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        if (dataDetail) {
            sb.append(DoublesUtil.getDataDetail(sketch));
        }
        if (sketchSummary) {
            sb.append(DoublesUtil.getSummary(sketch));
        }
        return sb.toString();
    }

    static String getDataDetail(DoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        sb.append(Util.LS).append("### ").append(thisSimpleName).append(" DATA DETAIL: ").append(Util.LS);
        int k = sketch.getK();
        long n = sketch.getN();
        int bbCount = sketch.getBaseBufferCount();
        long bitPattern = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        sb.append("   BaseBuffer   : ");
        for (int i = 0; i < bbCount; ++i) {
            sb.append(String.format("%10.1f", combBuf[i]));
        }
        sb.append(Util.LS);
        int combBufSize = combBuf.length;
        if (n >= (long)(2 * k)) {
            sb.append("   Valid | Level");
            for (int j = 2 * k; j < combBufSize; ++j) {
                if (j % k == 0) {
                    int levelNum = j / k - 2;
                    String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                    String lvl = String.format("%5d", levelNum);
                    sb.append(org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(": ");
                }
                sb.append(String.format("%10.1f", combBuf[j]));
            }
            sb.append(Util.LS);
        }
        sb.append("### END DATA DETAIL").append(Util.LS);
        return sb.toString();
    }

    static String getSummary(DoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sketch.getClass().getSimpleName();
        int k = sketch.getK();
        long n = sketch.getN();
        String nStr = String.format("%,d", n);
        int bbCount = sketch.getBaseBufferCount();
        long bitPattern = sketch.getBitPattern();
        int totLevels = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeNumLevelsNeeded(k, n);
        int validLevels = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeValidLevels(bitPattern);
        boolean empty = sketch.isEmpty();
        int preBytes = empty ? 8 : 16;
        int retItems = sketch.getRetainedItems();
        String retItemsStr = String.format("%,d", retItems);
        int bytes = preBytes + (retItems + 2) * 8;
        double eps = Util.EpsilonFromK.getAdjustedEpsilon(k);
        String epsPct = String.format("%.3f%%", eps * 100.0);
        sb.append(org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.LS).append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   K                            : ").append(k).append(Util.LS);
        sb.append("   N                            : ").append(nStr).append(Util.LS);
        sb.append("   Levels (Total, Valid)        : ").append(totLevels + ", " + validLevels).append(Util.LS);
        sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(Util.LS);
        sb.append("   BaseBufferCount              : ").append(bbCount).append(Util.LS);
        sb.append("   Retained Items               : ").append(retItemsStr).append(Util.LS);
        sb.append("   Storage Bytes                : ").append(String.format("%,d", bytes)).append(Util.LS);
        sb.append("   Normalized Rank Error        : ").append(epsPct).append(Util.LS);
        sb.append("   Min Value                    : ").append(String.format("%,.3f", sketch.getMinValue())).append(Util.LS);
        sb.append("   Max Value                    : ").append(String.format("%,.3f", sketch.getMaxValue())).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static String printMemData(Memory mem, int k, int n) {
        double d;
        int i;
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS).append("### ").append("MEM DATA DETAIL:").append(Util.LS);
        String fmt1 = "%n%10.1f, ";
        String fmt2 = "%10.1f, ";
        int bbCount = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeBaseBufferItems(k, n);
        int ret = org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util.computeRetainedItems(k, n);
        sb.append("BaseBuffer Data:");
        for (i = 0; i < bbCount; ++i) {
            d = mem.getDouble(32 + i * 8);
            if (i % k != 0) {
                sb.append(String.format("%10.1f, ", d));
                continue;
            }
            sb.append(String.format("%n%10.1f, ", d));
        }
        sb.append(Util.LS + Util.LS + "Level Data:");
        for (i = 0; i < ret - bbCount; ++i) {
            d = mem.getDouble(32 + i * 8 + bbCount * 8);
            if (i % k != 0) {
                sb.append(String.format("%10.1f, ", d));
                continue;
            }
            sb.append(String.format("%n%10.1f, ", d));
        }
        sb.append(Util.LS + "### END DATA DETAIL").append(Util.LS);
        return sb.toString();
    }
}

