/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles;

import java.util.Random;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.Memory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesAuxiliary;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesPmfCdfImpl;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesToByteArrayImpl;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesUtil;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.Util;

public abstract class DoublesSketch {
    static final int DOUBLES_SER_VER = 3;
    static final int MIN_DOUBLES_SER_VER = 2;
    protected final int k_;
    public static final Random rand = new Random();
    public static final int DEFAULT_K = 128;

    DoublesSketch(int k) {
        Util.checkK(k);
        this.k_ = k;
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public static DoublesSketch heapify(Memory srcMem) {
        return HeapDoublesSketch.heapifyInstance(srcMem);
    }

    public abstract void update(double var1);

    public double getQuantile(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new SketchesArgumentException("Fraction cannot be less than zero or greater than 1.0");
        }
        if (fraction == 0.0) {
            return this.getMinValue();
        }
        if (fraction == 1.0) {
            return this.getMaxValue();
        }
        DoublesAuxiliary aux = this.constructAuxiliary();
        return aux.getQuantile(fraction);
    }

    public double[] getQuantiles(double[] fractions) {
        Util.validateFractions(fractions);
        DoublesAuxiliary aux = null;
        double[] answers = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double fraction = fractions[i];
            if (fraction == 0.0) {
                answers[i] = this.getMinValue();
                continue;
            }
            if (fraction == 1.0) {
                answers[i] = this.getMaxValue();
                continue;
            }
            if (aux == null) {
                aux = this.constructAuxiliary();
            }
            answers[i] = aux.getQuantile(fraction);
        }
        return answers;
    }

    public double[] getQuantiles(int evenlySpaced) {
        return this.getQuantiles(DoublesSketch.getEvenlySpaced(evenlySpaced));
    }

    public double[] getPMF(double[] splitPoints) {
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, false);
    }

    public double[] getCDF(double[] splitPoints) {
        return DoublesPmfCdfImpl.getPMFOrCDF(this, splitPoints, true);
    }

    public abstract int getK();

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public abstract long getN();

    public double getNormalizedRankError() {
        return DoublesSketch.getNormalizedRankError(this.getK());
    }

    public static double getNormalizedRankError(int k) {
        return Util.EpsilonFromK.getAdjustedEpsilon(k);
    }

    public abstract boolean isEmpty();

    public abstract void reset();

    public byte[] toByteArray() {
        return this.toByteArray(false, true);
    }

    public byte[] toByteArray(boolean ordered) {
        return this.toByteArray(ordered, true);
    }

    public byte[] toByteArray(boolean ordered, boolean compact) {
        return DoublesToByteArrayImpl.toByteArray(this, ordered, compact);
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return DoublesUtil.toString(sketchSummary, dataDetail, this);
    }

    public abstract DoublesSketch downSample(int var1);

    public int getRetainedItems() {
        return Util.computeRetainedItems(this.getK(), this.getN());
    }

    public int getStorageBytes() {
        if (this.isEmpty()) {
            return 8;
        }
        return 32 + (Util.computeRetainedItems(this.getK(), this.getN()) << 3);
    }

    public int getStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        return 32 + (Util.computeRetainedItems(k, n) << 3);
    }

    public void putMemory(Memory dstMem) {
        this.putMemory(dstMem, false, true);
    }

    public void putMemory(Memory dstMem, boolean ordered) {
        this.putMemory(dstMem, ordered, true);
    }

    public void putMemory(Memory dstMem, boolean ordered, boolean compact) {
        byte[] byteArr = this.toByteArray(ordered, compact);
        int arrLen = byteArr.length;
        long memCap = dstMem.getCapacity();
        if (memCap < (long)arrLen) {
            throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
        }
        dstMem.putByteArray(0L, byteArr, 0, arrLen);
    }

    static double[] getEvenlySpaced(int evenlySpaced) {
        double frac;
        int n = evenlySpaced;
        if (n <= 0) {
            throw new SketchesArgumentException("EvenlySpaced must be > zero.");
        }
        double[] fractions = new double[n];
        fractions[0] = frac = 0.0;
        for (int i = 1; i < n; ++i) {
            fractions[i] = frac = (double)i / (double)(n - 1);
        }
        if (n > 1) {
            fractions[n - 1] = 1.0;
        }
        return fractions;
    }

    abstract int getBaseBufferCount();

    abstract long getBitPattern();

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();

    abstract void putCombinedBuffer(double[] var1);

    abstract void putMinValue(double var1);

    abstract void putMaxValue(double var1);

    abstract void putN(long var1);

    abstract void putCombinedBufferItemCapacity(int var1);

    abstract void putBaseBufferCount(int var1);

    abstract void putBitPattern(long var1);

    abstract Memory getMemory();

    DoublesAuxiliary constructAuxiliary() {
        return new DoublesAuxiliary(this);
    }
}

