/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles;

import java.util.Arrays;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.DoublesUpdateImpl;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.quantiles.HeapDoublesSketch;

class DoublesMergeImpl {
    DoublesMergeImpl() {
    }

    static void downSamplingMergeInto(HeapDoublesSketch src, HeapDoublesSketch tgt) {
        int targetK = tgt.getK();
        int sourceK = src.getK();
        if (sourceK % targetK != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = sourceK / targetK;
        Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        double[] sourceLevels = src.getCombinedBuffer();
        double[] sourceBaseBuffer = src.getCombinedBuffer();
        long nFinal = tgt.getN() + src.getN();
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(sourceBaseBuffer[i]);
        }
        DoublesUpdateImpl.maybeGrowLevels(nFinal, tgt);
        double[] scratchBuf = new double[2 * targetK];
        double[] downBuf = new double[targetK];
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                DoublesMergeImpl.justZipWithStride(sourceLevels, (2 + srcLvl) * sourceK, downBuf, 0, targetK, downFactor);
                DoublesUpdateImpl.inPlacePropagateCarry(srcLvl + lgDownFactor, downBuf, 0, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (long)(2 * targetK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        double srcMin = src.getMinValue();
        double tgtMax = tgt.getMaxValue();
        double tgtMin = tgt.getMinValue();
        if (srcMax > tgtMax) {
            tgt.putMaxValue(srcMax);
        }
        if (srcMin < tgtMin) {
            tgt.putMinValue(srcMin);
        }
    }

    private static void justZipWithStride(double[] bufA, int startA, double[] bufC, int startC, int kC, int stride) {
        int randomOffset = DoublesSketch.rand.nextInt(stride);
        int limC = startC + kC;
        int a = startA + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufA[a];
            a += stride;
        }
    }

    static void blockyTandemMergeSort(double[] keyArr, long[] valArr, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] keyTmp = Arrays.copyOf(keyArr, arrLen);
        long[] valTmp = Arrays.copyOf(valArr, arrLen);
        DoublesMergeImpl.blockyTandemMergeSortRecursion(keyTmp, valTmp, keyArr, valArr, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] keySrc, long[] valSrc, double[] keyDst, long[] valDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesMergeImpl.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesMergeImpl.blockyTandemMergeSortRecursion(keyDst, valDst, keySrc, valSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesMergeImpl.tandemMerge(keySrc, valSrc, arrStart1, arrLen1, arrStart2, arrLen2, keyDst, valDst, arrStart1);
    }

    private static void tandemMerge(double[] keySrc, long[] valSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] keyDst, long[] valDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (keySrc[i2] < keySrc[i1]) {
                keyDst[i3] = keySrc[i2];
                valDst[i3] = valSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            keyDst[i3] = keySrc[i1];
            valDst[i3] = valSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(keySrc, i1, keyDst, i3, arrStop1 - i1);
            System.arraycopy(valSrc, i1, valDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(keySrc, i2, keyDst, i3, arrStop2 - i2);
            System.arraycopy(valSrc, i2, valDst, i3, arrStop2 - i2);
        }
    }
}

