/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll;

import java.util.Arrays;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.memory.NativeMemory;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll.BucketIterator;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll.Fields;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll.HashUtils;

final class OnHeapHash {
    private int[] fields_;
    private int mask;
    private int numElements;

    OnHeapHash(int startSize) {
        this.resetFields(startSize);
    }

    void resetFields(int size) {
        this.fields_ = new int[size];
        Arrays.fill(this.fields_, -1);
        this.mask = this.fields_.length - 1;
        this.numElements = 0;
    }

    int[] getFields() {
        return this.fields_;
    }

    public int getNumElements() {
        return this.numElements;
    }

    void updateBucket(int key, byte val, Fields.UpdateCallback callback) {
        this.updateBucket(key, val, HashUtils.pairOfKeyAndVal(key, val), callback);
    }

    private int updateBucket(int key, byte val, int newField, Fields.UpdateCallback callback) {
        byte oldVal;
        int probe = key & this.mask;
        int field = this.fields_[probe];
        while (field != HashUtils.NOT_A_PAIR && key != HashUtils.keyOfPair(field)) {
            probe = probe + 1 & this.mask;
            field = this.fields_[probe];
        }
        if (field == HashUtils.NOT_A_PAIR) {
            this.fields_[probe] = newField;
            callback.bucketUpdated(key, (byte)0, val);
            ++this.numElements;
        }
        if ((oldVal = HashUtils.valOfPair(field)) < val) {
            this.fields_[probe] = newField;
            callback.bucketUpdated(key, oldVal, val);
            ++this.numElements;
        }
        return this.numElements;
    }

    int intoByteArray(byte[] array, int offset) {
        int numBytesNeeded = this.numBytesToSerialize();
        if (array.length - offset < numBytesNeeded) {
            throw new SketchesArgumentException(String.format("array too small[%,d] < [%,d]", array.length - offset, numBytesNeeded));
        }
        NativeMemory mem = new NativeMemory(array);
        for (int field : this.fields_) {
            mem.putInt(offset, field);
            offset += 4;
        }
        return offset;
    }

    int numBytesToSerialize() {
        return this.fields_.length << 2;
    }

    BucketIterator getBucketIterator() {
        return new BucketIterator(){
            private int i = -1;

            @Override
            public boolean next() {
                ++this.i;
                while (this.i < OnHeapHash.this.fields_.length && OnHeapHash.this.fields_[this.i] == HashUtils.NOT_A_PAIR) {
                    ++this.i;
                }
                return this.i < OnHeapHash.this.fields_.length;
            }

            @Override
            public int getKey() {
                return HashUtils.keyOfPair(OnHeapHash.this.fields_[this.i]);
            }

            @Override
            public byte getValue() {
                return HashUtils.valOfPair(OnHeapHash.this.fields_[this.i]);
            }
        };
    }

    void boostrap(int[] fields) {
        for (int field : fields) {
            if (field == HashUtils.NOT_A_PAIR) continue;
            this.updateBucket(HashUtils.keyOfPair(field), HashUtils.valOfPair(field), field, Fields.NOOP_CB);
        }
    }
}

