/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll;

import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.Util;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll.Fields;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll.HllSketch;

final class HipHllSketch
extends HllSketch {
    private static final double HIP_REL_ERROR_NUMER = 0.836083874576235;
    private double invPow2Sum = this.numBuckets();
    private double hipEstAccum = 0.0;

    public HipHllSketch(final Fields fields) {
        super(fields);
        this.setUpdateCallback(new Fields.UpdateCallback(){
            private int numBuckets;
            {
                this.numBuckets = fields.getPreamble().getConfigK();
            }

            @Override
            public void bucketUpdated(int bucket, byte oldVal, byte newVal) {
                double oneOverQ = this.oneOverQ();
                HipHllSketch.this.hipEstAccum = HipHllSketch.this.hipEstAccum + oneOverQ;
                HipHllSketch.this.invPow2Sum = HipHllSketch.this.invPow2Sum - Util.invPow2(oldVal);
                HipHllSketch.this.invPow2Sum = HipHllSketch.this.invPow2Sum + Util.invPow2(newVal);
            }

            private double oneOverQ() {
                return (double)this.numBuckets / HipHllSketch.this.invPow2Sum;
            }
        });
    }

    @Override
    public HllSketch union(HllSketch that) {
        throw new UnsupportedOperationException("HipHllSketches cannot handle merges, use a normal HllSketch");
    }

    @Override
    public double getUpperBound(double numStdDevs) {
        return this.hipEstAccum / (1.0 - this.eps(numStdDevs));
    }

    @Override
    public double getLowerBound(double numStdDevs) {
        double numNonZeros;
        int numBuckets;
        double lowerBound = this.hipEstAccum / (1.0 + this.eps(numStdDevs));
        if (lowerBound < (double)(numBuckets = this.numBuckets()) && lowerBound < (numNonZeros = (double)(numBuckets - this.numBucketsAtZero()))) {
            return numNonZeros;
        }
        return lowerBound;
    }

    @Override
    public double getEstimate() {
        return this.hipEstAccum;
    }

    @Override
    protected double inversePowerOf2Sum() {
        return this.invPow2Sum;
    }

    private double eps(double numStdDevs) {
        return numStdDevs * 0.836083874576235 / Math.sqrt(this.numBuckets());
    }
}

