/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.hll;

final class HarmonicNumbers {
    private static final int NUM_EXACT_HARMONIC_NUMBERS = 25;
    private static final double EULER_MASCHERONI_CONSTANT = 0.5772156649015329;
    private static double[] tableOfExactHarmonicNumbers = new double[]{0.0, 1.0, 1.5, 1.8333333333333333, 2.0833333333333335, 2.283333333333333, 2.45, 2.592857142857143, 2.717857142857143, 2.828968253968254, 2.9289682539682538, 3.019877344877345, 3.103210678210678, 3.180133755133755, 3.2515623265623264, 3.3182289932289932, 3.3807289932289932, 3.4395525226407577, 3.4951080781963135, 3.547739657143682, 3.597739657143682, 3.6453587047627294, 3.690813250217275, 3.73429151108684, 3.7759581777535067};

    private HarmonicNumbers() {
    }

    public static double harmonicNumber(long x_i) {
        if (x_i < 25L) {
            return tableOfExactHarmonicNumbers[(int)x_i];
        }
        double x = x_i;
        double invSq = 1.0 / (x * x);
        double sum = Math.log(x) + 0.5772156649015329 + 1.0 / (2.0 * x);
        double pow = invSq;
        sum -= pow * 0.08333333333333333;
        sum += (pow *= invSq) * 0.008333333333333333;
        sum -= (pow *= invSq) * 0.003968253968253968;
        return sum += (pow *= invSq) * 0.004166666666666667;
    }
}

