/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches;

import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.BoundsOnRatiosInSampledSets;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.SketchesArgumentException;
import org.apache.pulsar.v3_0_8.shade.com.yahoo.sketches.theta.Sketch;

public final class BoundsOnRatiosInThetaSketchedSets {
    private BoundsOnRatiosInThetaSketchedSets() {
    }

    public static double getLowerBoundForBoverA(Sketch sketchA, Sketch sketchB) {
        int countA;
        double thetaA = sketchA.getTheta();
        double thetaB = sketchB.getTheta();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaA, thetaB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaB == thetaA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanTheta(thetaB);
        if (countA <= 0) {
            return 0.0;
        }
        return BoundsOnRatiosInSampledSets.getLowerBoundForBoverA(countA, countB, thetaB);
    }

    public static double getUpperBoundForBoverA(Sketch sketchA, Sketch sketchB) {
        int countA;
        double thetaA = sketchA.getTheta();
        double thetaB = sketchB.getTheta();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaA, thetaB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaB == thetaA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanTheta(thetaB);
        if (countA <= 0) {
            return 1.0;
        }
        return BoundsOnRatiosInSampledSets.getUpperBoundForBoverA(countA, countB, thetaB);
    }

    public static double getEstimateOfBoverA(Sketch sketchA, Sketch sketchB) {
        int countA;
        double thetaA = sketchA.getTheta();
        double thetaB = sketchB.getTheta();
        BoundsOnRatiosInThetaSketchedSets.checkThetas(thetaA, thetaB);
        int countB = sketchB.getRetainedEntries(true);
        int n = countA = thetaB == thetaA ? sketchA.getRetainedEntries(true) : sketchA.getCountLessThanTheta(thetaB);
        if (countA <= 0) {
            return 0.5;
        }
        return (double)countB / (double)countA;
    }

    static void checkThetas(double thetaA, double thetaB) {
        if (thetaB > thetaA) {
            throw new SketchesArgumentException("ThetaB cannot be > ThetaA.");
        }
    }
}

