/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.spotify.futures;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;

public final class CombinedFutures {
    private static final Object NULL_PLACEHOLDER = new Object();
    private final IdentityHashMap<CompletionStage<?>, Object> map = new IdentityHashMap();

    CombinedFutures(List<? extends CompletionStage<?>> stages) {
        for (CompletionStage<?> stage : stages) {
            Object value = stage.toCompletableFuture().join();
            if (value == null) {
                value = NULL_PLACEHOLDER;
            }
            this.map.put(stage, value);
        }
    }

    public <T> T get(CompletionStage<T> stage) {
        Object value = this.map.get(stage);
        if (value == null) {
            throw new IllegalArgumentException("Can not resolve values for futures that were not part of the combine");
        }
        if (value == NULL_PLACEHOLDER) {
            return null;
        }
        return (T)value;
    }
}

