/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.crc;

import java.nio.ByteBuffer;
import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.IncrementalIntHash;
import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.impl.AbstractIncrementalIntHash;
import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.params.CrcParameters;
import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.utils.NativeUtils;

public final class Sse42Crc32C
extends AbstractIncrementalIntHash
implements IncrementalIntHash {
    private static final boolean SUPPORTED = Sse42Crc32C.checkSupported();
    private final long config;

    private static boolean checkSupported() {
        try {
            NativeUtils.loadLibraryFromJar("/lib/libcirce-checksum." + NativeUtils.libType());
            return Sse42Crc32C.nativeSupported();
        }
        catch (Exception | UnsatisfiedLinkError e) {
            return false;
        }
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    Sse42Crc32C() {
        this.config = 0L;
    }

    public Sse42Crc32C(int[] chunkWords) {
        if (chunkWords.length == 0) {
            this.config = 0L;
        } else {
            this.config = Sse42Crc32C.allocConfig(chunkWords);
            if (this.config == 0L) {
                throw new RuntimeException("CRC32C configuration allocation failed");
            }
        }
    }

    protected void finalize() {
        if (this.config != 0L) {
            Sse42Crc32C.freeConfig(this.config);
        }
    }

    @Override
    public String algorithm() {
        return CrcParameters.CRC32C.algorithm();
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public boolean supportsUnsafe() {
        return true;
    }

    @Override
    public int calculate(long address, long length) {
        return Sse42Crc32C.nativeUnsafe(this.initial(), address, length, this.config);
    }

    @Override
    public int resume(int current, ByteBuffer input) {
        if (input.isDirect()) {
            int result = Sse42Crc32C.nativeDirectBuffer(current, input, input.position(), input.remaining(), this.config);
            input.position(input.limit());
            return result;
        }
        return super.resume(current, input);
    }

    @Override
    public int resume(int current, long address, long length) {
        return Sse42Crc32C.nativeUnsafe(current, address, length, this.config);
    }

    @Override
    protected int initial() {
        return 0;
    }

    @Override
    protected int resumeUnchecked(int current, byte[] input, int index, int length) {
        return Sse42Crc32C.nativeArray(current, input, index, length, this.config);
    }

    private static native boolean nativeSupported();

    private static native int nativeArray(int var0, byte[] var1, int var2, int var3, long var4);

    private static native int nativeDirectBuffer(int var0, ByteBuffer var1, int var2, int var3, long var4);

    private static native int nativeUnsafe(int var0, long var1, long var3, long var5);

    private static native long allocConfig(int[] var0);

    private static native void freeConfig(long var0);
}

