/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.crc;

import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.crc.AbstractIntCrc;

final class NormalIntCrc
extends AbstractIntCrc {
    private final int widthMask;
    private final int[] table = new int[256];

    NormalIntCrc(String algorithm, int bitWidth, int poly, int init, int xorOut) {
        super(algorithm, bitWidth, init, xorOut);
        if (bitWidth < 8) {
            throw new IllegalArgumentException("invalid CRC width");
        }
        this.widthMask = bitWidth < 32 ? (1 << bitWidth) - 1 : -1;
        int top = 1 << bitWidth - 1;
        for (int i = 0; i < 256; ++i) {
            int crc = i << bitWidth - 8;
            for (int j = 0; j < 8; ++j) {
                crc = (crc & top) != 0 ? crc << 1 ^ poly : crc << 1;
            }
            this.table[i] = crc & this.widthMask;
        }
    }

    @Override
    protected int resumeRaw(int crc, byte[] input, int index, int length) {
        for (int i = 0; i < length; ++i) {
            crc = this.table[(crc >>> this.bitWidth - 8 ^ input[index + i]) & 0xFF] ^ crc << 8;
        }
        return crc & this.widthMask;
    }
}

