/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.crc;

import org.apache.pulsar.v3_0_8.shade.com.scurrilous.circe.impl.AbstractIncrementalLongHash;

abstract class AbstractLongCrc
extends AbstractIncrementalLongHash {
    private final String algorithm;
    protected final int bitWidth;
    private final long initial;
    private final long xorOut;

    AbstractLongCrc(String algorithm, int bitWidth, long initial, long xorOut) {
        if (bitWidth < 1 || bitWidth > 64) {
            throw new IllegalArgumentException("invalid CRC width");
        }
        this.algorithm = algorithm;
        this.bitWidth = bitWidth;
        this.initial = initial;
        this.xorOut = xorOut;
    }

    @Override
    public String algorithm() {
        return this.algorithm;
    }

    @Override
    public int length() {
        return (this.bitWidth + 7) / 8;
    }

    @Override
    protected long initial() {
        return this.initial ^ this.xorOut;
    }

    @Override
    protected long resumeUnchecked(long current, byte[] input, int index, int length) {
        return this.resumeRaw(current ^ this.xorOut, input, index, length) ^ this.xorOut;
    }

    protected abstract long resumeRaw(long var1, byte[] var3, int var4, int var5);

    protected final long reflect(long value) {
        return Long.reverse(value) >>> 64 - this.bitWidth;
    }
}

