/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.types.AdditionalPropertiesDeserializer;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;

public class ObjectSchema
extends ContainerTypeSchema {
    @JsonProperty
    private AdditionalProperties additionalProperties;
    @JsonProperty
    private Map<String, Object> dependencies = new LinkedHashMap<String, Object>();
    @JsonProperty
    private Map<String, JsonSchema> patternProperties = new LinkedHashMap<String, JsonSchema>();
    @JsonProperty
    private Map<String, JsonSchema> properties = new LinkedHashMap<String, JsonSchema>();

    public boolean addSchemaDependency(String depender, JsonSchema parentMustMatch) {
        this.dependencies.put(depender, parentMustMatch);
        return this.dependencies.get(depender).equals(parentMustMatch);
    }

    public boolean addSimpleDependency(String depender, String dependsOn) {
        LinkedHashSet<String> existingDependsOn = (LinkedHashSet<String>)this.dependencies.get(depender);
        if (existingDependsOn == null) {
            existingDependsOn = new LinkedHashSet<String>();
            this.dependencies.put(depender, existingDependsOn);
        }
        return existingDependsOn.add(dependsOn);
    }

    @Override
    public JsonFormatTypes getType() {
        return JsonFormatTypes.OBJECT;
    }

    @Override
    public boolean isObjectSchema() {
        return true;
    }

    @Override
    public ObjectSchema asObjectSchema() {
        return this;
    }

    public AdditionalProperties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, Object> getDependencies() {
        return this.dependencies;
    }

    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    public void putOptionalProperty(BeanProperty property, JsonSchema jsonSchema) {
        jsonSchema.enrichWithBeanProperty(property);
        this.properties.put(property.getName(), jsonSchema);
    }

    public void putOptionalProperty(String name, JsonSchema jsonSchema) {
        this.properties.put(name, jsonSchema);
    }

    public JsonSchema putPatternProperty(String regex, JsonSchema value) {
        return this.patternProperties.put(regex, value);
    }

    public JsonSchema putProperty(BeanProperty property, JsonSchema value) {
        value.setRequired(true);
        value.enrichWithBeanProperty(property);
        return this.properties.put(property.getName(), value);
    }

    public JsonSchema putProperty(String name, JsonSchema value) {
        value.setRequired(true);
        return this.properties.put(name, value);
    }

    public void rejectAdditionalProperties() {
        this.additionalProperties = NoAdditionalProperties.instance;
    }

    public void setAdditionalProperties(AdditionalProperties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setDependencies(Map<String, Object> dependencies) {
        this.dependencies = dependencies;
    }

    public void setPatternProperties(Map<String, JsonSchema> patternProperties) {
        this.patternProperties = patternProperties;
    }

    public void setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectSchema)) {
            return false;
        }
        return this._equals((ObjectSchema)obj);
    }

    protected boolean _equals(ObjectSchema that) {
        return ObjectSchema.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && ObjectSchema.equals(this.getDependencies(), that.getDependencies()) && ObjectSchema.equals(this.getPatternProperties(), that.getPatternProperties()) && ObjectSchema.equals(this.getProperties(), that.getProperties()) && super._equals(that);
    }

    public static class SimpleDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private String dependsOn;

        public SimpleDependency(String depender, String dependsOn) {
            this.depender = depender;
            this.dependsOn = dependsOn;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchemaDependency) {
                SimpleDependency that = (SimpleDependency)obj;
                return ObjectSchema.equals(this.getDepender(), that.getDepender()) && ObjectSchema.equals(this.getDependsOn(), that.getDependsOn());
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public String getDependsOn() {
            return this.dependsOn;
        }
    }

    public static class SchemaDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private JsonSchema parentMustMatch;

        public SchemaDependency(String depender, JsonSchema parentMustMatch) {
            this.depender = depender;
            this.parentMustMatch = parentMustMatch;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchemaDependency) {
                SchemaDependency that = (SchemaDependency)obj;
                return ObjectSchema.equals(this.getDepender(), that.getDepender()) && ObjectSchema.equals(this.getParentMustMatch(), that.getParentMustMatch());
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public JsonSchema getParentMustMatch() {
            return this.parentMustMatch;
        }
    }

    public static class SchemaAdditionalProperties
    extends AdditionalProperties {
        @JsonProperty
        private JsonSchema jsonSchema;

        public boolean equals(Object obj) {
            return obj instanceof SchemaAdditionalProperties && ObjectSchema.equals(this.getJsonSchema(), ((SchemaAdditionalProperties)obj).getJsonSchema());
        }

        @JsonValue
        public JsonSchema getJsonSchema() {
            return this.jsonSchema;
        }

        public SchemaAdditionalProperties(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }
    }

    public static class NoAdditionalProperties
    extends AdditionalProperties {
        public final Boolean schema = false;
        public static final NoAdditionalProperties instance = new NoAdditionalProperties();

        protected NoAdditionalProperties() {
        }

        public boolean equals(Object obj) {
            return obj instanceof NoAdditionalProperties;
        }

        @JsonValue
        public Boolean value() {
            return this.schema;
        }
    }

    public static abstract class Dependency {
        @JsonCreator
        public Dependency jsonCreator() {
            return null;
        }
    }

    @JsonDeserialize(using=AdditionalPropertiesDeserializer.class)
    public static abstract class AdditionalProperties {
    }
}

