/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories;

import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.JavaType;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements JsonSchemaProducer,
Visitor {
    protected final ArraySchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory;
    private VisitorContext visitorContext;

    public ArrayVisitor(SerializerProvider provider, ArraySchema schema) {
        this(provider, schema, new WrapperFactory());
    }

    public ArrayVisitor(SerializerProvider provider, ArraySchema schema, WrapperFactory wrapperFactory) {
        this.provider = provider;
        this.schema = schema;
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public SerializerProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public void itemsFormat(JsonFormatVisitable handler, JavaType contentType) throws JsonMappingException {
        if (contentType.getRawClass() != Object.class) {
            String seenSchemaUri;
            if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(contentType)) != null) {
                this.schema.setItemsSchema(new ReferenceSchema(seenSchemaUri));
                return;
            }
            SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
            handler.acceptJsonFormatVisitor(visitor, contentType);
            this.schema.setItemsSchema(visitor.finalSchema());
        }
    }

    @Override
    public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
        this.schema.setItemsSchema(JsonSchema.minimalForFormat(format));
    }

    @Override
    public Visitor setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }
}

