/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util.collections;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.v3_0_8.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.v3_0_8.shade.io.netty.util.internal.MathUtil;

public class GrowablePriorityLongPairQueue {
    private long[] data;
    private int capacity;
    private static final AtomicIntegerFieldUpdater<GrowablePriorityLongPairQueue> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GrowablePriorityLongPairQueue.class, "size");
    private volatile int size = 0;
    private static final long EmptyItem = -1L;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public GrowablePriorityLongPairQueue() {
        this(64);
    }

    public GrowablePriorityLongPairQueue(int initialCapacity) {
        Preconditions.checkArgument(initialCapacity > 0);
        this.capacity = MathUtil.findNextPositivePowerOfTwo(initialCapacity);
        this.data = new long[2 * this.capacity];
        Arrays.fill(this.data, 0, this.data.length, -1L);
    }

    public synchronized void add(long item1, long item2) {
        if (this.size >= this.capacity) {
            this.expandArray();
        }
        int lastIndex = this.size << 1;
        this.data[lastIndex] = item1;
        this.data[lastIndex + 1] = item2;
        int loc = lastIndex;
        while (loc > 0 && this.compare(loc, GrowablePriorityLongPairQueue.parent(loc)) < 0) {
            this.swap(loc, GrowablePriorityLongPairQueue.parent(loc));
            loc = GrowablePriorityLongPairQueue.parent(loc);
        }
        SIZE_UPDATER.incrementAndGet(this);
    }

    public synchronized void forEach(LongPairConsumer processor) {
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            processor.accept(this.data[index], this.data[index + 1]);
            index += 2;
        }
    }

    public Set<LongPair> items() {
        HashSet<LongPair> items = new HashSet<LongPair>(this.size);
        this.forEach((item1, item2) -> items.add(new LongPair(item1, item2)));
        return items;
    }

    public Set<LongPair> items(int numberOfItems) {
        HashSet<LongPair> items = new HashSet<LongPair>(this.size);
        this.forEach((item1, item2) -> {
            if (items.size() < numberOfItems) {
                items.add(new LongPair(item1, item2));
            }
        });
        return items;
    }

    public synchronized int removeIf(LongPairPredicate filter) {
        int removedValues = 0;
        int index = 0;
        long[] deletedItems = new long[this.size * 2];
        int deleteItemsIndex = 0;
        for (int i = 0; i < this.size; ++i) {
            if (filter.test(this.data[index], this.data[index + 1])) {
                deletedItems[deleteItemsIndex++] = this.data[index];
                deletedItems[deleteItemsIndex++] = this.data[index + 1];
                ++removedValues;
            }
            index += 2;
        }
        deleteItemsIndex = 0;
        for (int deleteItem = 0; deleteItem < removedValues; ++deleteItem) {
            index = 0;
            for (int i = 0; i < this.size; ++i) {
                if (this.data[index] == deletedItems[deleteItemsIndex] && this.data[index + 1] == deletedItems[deleteItemsIndex + 1]) {
                    this.removeAtWithoutLock(index);
                }
                index += 2;
            }
            deleteItemsIndex += 2;
        }
        return removedValues;
    }

    public synchronized boolean remove(long item1, long item2) {
        boolean removed = false;
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[index] == item1 && this.data[index + 1] == item2) {
                this.removeAtWithoutLock(index);
                removed = true;
            }
            index += 2;
        }
        return removed;
    }

    public LongPair remove() {
        return this.removeAt(0);
    }

    private synchronized LongPair removeAt(int index) {
        return this.removeAtWithoutLock(index);
    }

    private LongPair removeAtWithoutLock(int index) {
        if (this.size > 0) {
            LongPair item = new LongPair(this.data[index], this.data[index + 1]);
            this.data[index] = -1L;
            this.data[index + 1] = -1L;
            SIZE_UPDATER.decrementAndGet(this);
            int lastIndex = this.size << 1;
            this.swap(index, lastIndex);
            this.minHeapify(index, lastIndex - 2);
            return item;
        }
        return null;
    }

    public synchronized LongPair peek() {
        if (this.size > 0) {
            return new LongPair(this.data[0], this.data[1]);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public synchronized void clear() {
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            this.data[index] = -1L;
            this.data[index + 1] = -1L;
            index += 2;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized boolean exists(long item1, long item2) {
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[index] == item1 && this.data[index + 1] == item2) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    private int compare(int index1, int index2) {
        if (this.data[index1] != this.data[index2]) {
            return Long.compare(this.data[index1], this.data[index2]);
        }
        return Long.compare(this.data[index1 + 1], this.data[index2 + 1]);
    }

    private void expandArray() {
        this.capacity *= 2;
        long[] newData = new long[2 * this.capacity];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            newData[index] = this.data[index];
            newData[index + 1] = this.data[index + 1];
            index += 2;
        }
        Arrays.fill(newData, index, newData.length, -1L);
        this.data = newData;
    }

    private void swap(int i, int j) {
        long t2 = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = t2;
        t2 = this.data[i + 1];
        this.data[i + 1] = this.data[j + 1];
        this.data[j + 1] = t2;
    }

    private static int leftChild(int i) {
        return (i << 1) + 2;
    }

    private static int rightChild(int i) {
        return (i << 1) + 4;
    }

    private static int parent(int i) {
        return i - 2 >> 1 & 0xFFFFFFFE;
    }

    private void minHeapify(int index, int lastIndex) {
        int left = GrowablePriorityLongPairQueue.leftChild(index);
        int right = GrowablePriorityLongPairQueue.rightChild(index);
        int smallest = left <= lastIndex && this.compare(left, index) < 0 ? left : index;
        if (right <= lastIndex && this.compare(right, smallest) < 0) {
            smallest = right;
        }
        if (smallest != index) {
            this.swap(index, smallest);
            this.minHeapify(smallest, lastIndex);
        }
    }

    static final long hash(long key1, long key2) {
        long hash = key1 * -4132994306676758123L;
        hash ^= hash >>> 47;
        hash *= -4132994306676758123L;
        hash += 31L + key2 * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    public static interface LongPairConsumer {
        public void accept(long var1, long var3);
    }

    public static interface LongPairPredicate {
        public boolean test(long var1, long var3);
    }

    public static class LongPair
    implements Comparable<LongPair> {
        public final long first;
        public final long second;

        public LongPair(long first, long second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LongPair) {
                LongPair other = (LongPair)obj;
                return this.first == other.first && this.second == other.second;
            }
            return false;
        }

        public int hashCode() {
            return (int)GrowablePriorityLongPairQueue.hash(this.first, this.second);
        }

        @Override
        public int compareTo(LongPair o) {
            if (this.first != o.first) {
                return Long.compare(this.first, o.first);
            }
            return Long.compare(this.second, o.second);
        }

        public String toString() {
            return "LongPair [first=" + this.first + ", second=" + this.second + "]";
        }
    }
}

