/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util.collections;

import java.util.BitSet;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.IntStream;

public class ConcurrentBitSet
extends BitSet {
    private static final long serialVersionUID = 1L;
    private final StampedLock rwLock = new StampedLock();

    public ConcurrentBitSet() {
    }

    public ConcurrentBitSet(int nbits) {
        super(nbits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean get(int bitIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isSet = super.get(bitIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isSet = super.get(bitIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int bitIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.set(bitIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(int bitIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.clear(bitIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int fromIndex, int toIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.set(fromIndex, toIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(int fromIndex, int toIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.clear(fromIndex, toIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    @Override
    public void clear() {
        long stamp = this.rwLock.writeLock();
        try {
            super.clear();
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextSetBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int nextSetBit = super.nextSetBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                nextSetBit = super.nextSetBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return nextSetBit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextClearBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int nextClearBit = super.nextClearBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                nextClearBit = super.nextClearBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return nextClearBit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousSetBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int previousSetBit = super.previousSetBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                previousSetBit = super.previousSetBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return previousSetBit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousClearBit(int fromIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        int previousClearBit = super.previousClearBit(fromIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                previousClearBit = super.previousClearBit(fromIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return previousClearBit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEmpty = super.isEmpty();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEmpty = super.isEmpty();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cardinality() {
        long stamp = this.rwLock.tryOptimisticRead();
        int cardinality = super.cardinality();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                cardinality = super.cardinality();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long stamp = this.rwLock.tryOptimisticRead();
        int size = super.size();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                size = super.size();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toByteArray() {
        long stamp = this.rwLock.tryOptimisticRead();
        byte[] byteArray = super.toByteArray();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                byteArray = super.toByteArray();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] toLongArray() {
        long stamp = this.rwLock.tryOptimisticRead();
        long[] longArray = super.toLongArray();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                longArray = super.toLongArray();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return longArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(int bitIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.flip(bitIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(int fromIndex, int toIndex) {
        long stamp = this.rwLock.writeLock();
        try {
            super.flip(fromIndex, toIndex);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int bitIndex, boolean value) {
        long stamp = this.rwLock.writeLock();
        try {
            super.set(bitIndex, value);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        long stamp = this.rwLock.writeLock();
        try {
            super.set(fromIndex, toIndex, value);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BitSet get(int fromIndex, int toIndex) {
        long stamp = this.rwLock.tryOptimisticRead();
        BitSet bitSet = super.get(fromIndex, toIndex);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                bitSet = super.get(fromIndex, toIndex);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return bitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int safeLength() {
        long stamp = this.rwLock.tryOptimisticRead();
        int length = super.length();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                length = super.length();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersects(BitSet set) {
        long stamp = this.rwLock.writeLock();
        try {
            boolean bl = super.intersects(set);
            return bl;
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void and(BitSet set) {
        long stamp = this.rwLock.writeLock();
        try {
            super.and(set);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void or(BitSet set) {
        long stamp = this.rwLock.writeLock();
        try {
            super.or(set);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xor(BitSet set) {
        long stamp = this.rwLock.writeLock();
        try {
            super.xor(set);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andNot(BitSet set) {
        long stamp = this.rwLock.writeLock();
        try {
            super.andNot(set);
        }
        finally {
            this.rwLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        long stamp = this.rwLock.tryOptimisticRead();
        BitSet clonedBitSet = (BitSet)super.clone();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                clonedBitSet = (BitSet)super.clone();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return clonedBitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        long stamp = this.rwLock.tryOptimisticRead();
        String str = super.toString();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                str = super.toString();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return str;
    }

    @Override
    public IntStream stream() {
        throw new UnsupportedOperationException("stream is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConcurrentBitSet)) {
            return false;
        }
        long stamp = this.rwLock.tryOptimisticRead();
        boolean isEqual = super.equals(o);
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                isEqual = super.equals(o);
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return isEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        long stamp = this.rwLock.tryOptimisticRead();
        int hashCode = super.hashCode();
        if (!this.rwLock.validate(stamp)) {
            stamp = this.rwLock.readLock();
            try {
                hashCode = super.hashCode();
            }
            finally {
                this.rwLock.unlockRead(stamp);
            }
        }
        return hashCode;
    }
}

