/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.v3_0_8.common.tls.TlsHostnameVerifier;
import org.apache.pulsar.v3_0_8.common.util.KeyManagerProxy;
import org.apache.pulsar.v3_0_8.common.util.KeyStoreHolder;
import org.apache.pulsar.v3_0_8.common.util.TrustManagerProxy;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.ClientAuth;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.SslContextBuilder;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.v3_0_8.shade.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.pulsar.v3_0_8.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityUtility.class);
    public static final Provider BC_PROVIDER = SecurityUtility.getProvider();
    public static final String BC_FIPS_PROVIDER_CLASS = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    public static final String BC_NON_FIPS_PROVIDER_CLASS = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String CONSCRYPT_PROVIDER_CLASS = "org.conscrypt.OpenSSLProvider";
    public static final Provider CONSCRYPT_PROVIDER = SecurityUtility.loadConscryptProvider();
    public static final String BC_FIPS = "BCFIPS";
    public static final String BC = "BC";

    public static boolean isBCFIPS() {
        return BC_PROVIDER.getClass().getCanonicalName().equals(BC_FIPS_PROVIDER_CLASS);
    }

    public static Provider getProvider() {
        boolean isProviderInstalled;
        boolean bl = isProviderInstalled = Security.getProvider(BC) != null || Security.getProvider(BC_FIPS) != null;
        if (isProviderInstalled) {
            Provider provider;
            Provider provider2 = provider = Security.getProvider(BC) != null ? Security.getProvider(BC) : Security.getProvider(BC_FIPS);
            if (log.isDebugEnabled()) {
                log.debug("Already instantiated Bouncy Castle provider {}", (Object)provider.getName());
            }
            return provider;
        }
        try {
            return SecurityUtility.getBCProviderFromClassPath();
        }
        catch (Exception e) {
            log.warn("Not able to get Bouncy Castle provider for both FIPS and Non-FIPS from class path:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Provider loadConscryptProvider() {
        Provider provider;
        Class<?> conscryptClazz;
        try {
            conscryptClazz = Class.forName("org.conscrypt.Conscrypt");
            conscryptClazz.getMethod("checkAvailability", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException) {
                log.debug("Conscrypt isn't available in the classpath. Using JDK default security provider.");
            } else if (e.getCause() instanceof UnsatisfiedLinkError) {
                log.debug("Conscrypt isn't available for {} {}. Using JDK default security provider.", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.arch"));
            } else {
                log.debug("Conscrypt isn't available. Using JDK default security provider. Cause : {}, Reason : {}", (Object)e.getCause(), (Object)e.getMessage());
            }
            return null;
        }
        try {
            provider = (Provider)Class.forName(CONSCRYPT_PROVIDER_CLASS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.debug("Unable to get security provider for class {}", (Object)CONSCRYPT_PROVIDER_CLASS, (Object)e);
            return null;
        }
        try {
            TlsHostnameVerifier hostnameVerifier = new TlsHostnameVerifier();
            Object wrappedHostnameVerifier = conscryptClazz.getMethod("wrapHostnameVerifier", HostnameVerifier.class).invoke(null, hostnameVerifier);
            Method setDefaultHostnameVerifierMethod = conscryptClazz.getMethod("setDefaultHostnameVerifier", Class.forName("org.conscrypt.ConscryptHostnameVerifier"));
            setDefaultHostnameVerifierMethod.invoke(null, wrappedHostnameVerifier);
        }
        catch (Exception e) {
            log.warn("Unable to set default hostname verifier for Conscrypt", (Throwable)e);
        }
        Security.addProvider(provider);
        if (log.isDebugEnabled()) {
            log.debug("Added security provider '{}' from class {}", (Object)provider.getName(), (Object)CONSCRYPT_PROVIDER_CLASS);
        }
        return provider;
    }

    public static Provider getBCProviderFromClassPath() throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(BC_NON_FIPS_PROVIDER_CLASS);
        }
        catch (ClassNotFoundException cnf) {
            log.warn("Not able to get Bouncy Castle provider: {}, try to get FIPS provider {}", (Object)BC_NON_FIPS_PROVIDER_CLASS, (Object)BC_FIPS_PROVIDER_CLASS);
            clazz = Class.forName(BC_FIPS_PROVIDER_CLASS);
        }
        Provider provider = (Provider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Security.addProvider(provider);
        if (log.isDebugEnabled()) {
            log.debug("Found and Instantiated Bouncy Castle provider in classpath {}", (Object)provider.getName());
        }
        return provider;
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertificates, String providerName) throws GeneralSecurityException {
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, null, null, providerName);
    }

    public static SslContext createNettySslContextForClient(SslProvider sslProvider, boolean allowInsecureConnection, String trustCertsFilePath, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        return SecurityUtility.createNettySslContextForClient(sslProvider, allowInsecureConnection, trustCertsFilePath, (Certificate[])null, (PrivateKey)null, ciphers, protocols);
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath, String providerName) throws GeneralSecurityException {
        Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile(trustCertsFilePath);
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertificates, certificates, privateKey, providerName);
    }

    public static SslContext createAutoRefreshSslContextForClient(SslProvider sslProvider, boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath, String sslContextAlgorithm, int refreshDurationSec, ScheduledExecutorService executor) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        KeyManagerProxy keyManager = new KeyManagerProxy(certFilePath, keyFilePath, refreshDurationSec, executor);
        SslContextBuilder sslContexBuilder = SslContextBuilder.forClient().sslProvider(sslProvider);
        sslContexBuilder.keyManager(keyManager);
        if (allowInsecureConnection) {
            sslContexBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (StringUtils.isNotBlank(trustCertsFilePath)) {
            TrustManagerProxy trustManager = new TrustManagerProxy(trustCertsFilePath, refreshDurationSec, executor);
            sslContexBuilder.trustManager(trustManager);
        }
        return sslContexBuilder.build();
    }

    public static SslContext createNettySslContextForClient(SslProvider sslProvider, boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        return SecurityUtility.createNettySslContextForClient(sslProvider, allowInsecureConnection, trustCertsFilePath, certificates, privateKey, ciphers, protocols);
    }

    public static SslContext createNettySslContextForClient(SslProvider sslProvider, boolean allowInsecureConnection, String trustCertsFilePath, Certificate[] certificates, PrivateKey privateKey, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        if (StringUtils.isNotBlank(trustCertsFilePath)) {
            try (FileInputStream trustCertsStream = new FileInputStream(trustCertsFilePath);){
                SslContext sslContext = SecurityUtility.createNettySslContextForClient(sslProvider, allowInsecureConnection, trustCertsStream, certificates, privateKey, ciphers, protocols);
                return sslContext;
            }
        }
        return SecurityUtility.createNettySslContextForClient(sslProvider, allowInsecureConnection, (InputStream)null, certificates, privateKey, ciphers, protocols);
    }

    public static SslContext createNettySslContextForClient(SslProvider sslProvider, boolean allowInsecureConnection, InputStream trustCertsStream, Certificate[] certificates, PrivateKey privateKey, Set<String> ciphers, Set<String> protocols) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(sslProvider);
        SecurityUtility.setupTrustCerts(builder, allowInsecureConnection, trustCertsStream);
        SecurityUtility.setupKeyManager(builder, privateKey, (X509Certificate[])certificates);
        SecurityUtility.setupCiphers(builder, ciphers);
        SecurityUtility.setupProtocols(builder, protocols);
        return builder.build();
    }

    public static SslContext createNettySslContextForServer(SslProvider sslProvider, boolean allowInsecureConnection, String trustCertsFilePath, String certFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols, boolean requireTrustedClientCertOnConnect) throws GeneralSecurityException, SSLException, FileNotFoundException, IOException {
        X509Certificate[] certificates = SecurityUtility.loadCertificatesFromPemFile(certFilePath);
        PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(keyFilePath);
        SslContextBuilder builder = SslContextBuilder.forServer(privateKey, certificates).sslProvider(sslProvider);
        SecurityUtility.setupCiphers(builder, ciphers);
        SecurityUtility.setupProtocols(builder, protocols);
        if (StringUtils.isNotBlank(trustCertsFilePath)) {
            try (FileInputStream trustCertsStream = new FileInputStream(trustCertsFilePath);){
                SecurityUtility.setupTrustCerts(builder, allowInsecureConnection, trustCertsStream);
            }
        } else {
            SecurityUtility.setupTrustCerts(builder, allowInsecureConnection, null);
        }
        SecurityUtility.setupKeyManager(builder, privateKey, certificates);
        SecurityUtility.setupClientAuthentication(builder, requireTrustedClientCertOnConnect);
        return builder.build();
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertficates, Certificate[] certificates, PrivateKey privateKey) throws GeneralSecurityException {
        return SecurityUtility.createSslContext(allowInsecureConnection, trustCertficates, certificates, privateKey, null);
    }

    public static SSLContext createSslContext(boolean allowInsecureConnection, Certificate[] trustCertficates, Certificate[] certificates, PrivateKey privateKey, String providerName) throws GeneralSecurityException {
        KeyStoreHolder ksh = new KeyStoreHolder();
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        Provider provider = SecurityUtility.resolveProvider(providerName);
        trustManagers = SecurityUtility.setupTrustCerts(ksh, allowInsecureConnection, trustCertficates, provider);
        keyManagers = SecurityUtility.setupKeyManager(ksh, privateKey, certificates);
        SSLContext sslCtx = provider != null ? SSLContext.getInstance("TLS", provider) : SSLContext.getInstance("TLS");
        sslCtx.init(keyManagers, trustManagers, new SecureRandom());
        return sslCtx;
    }

    private static KeyManager[] setupKeyManager(KeyStoreHolder ksh, PrivateKey privateKey, Certificate[] certificates) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        if (certificates != null && privateKey != null) {
            ksh.setPrivateKey("private", privateKey, certificates);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksh.getKeyStore(), "".toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        return keyManagers;
    }

    private static TrustManager[] setupTrustCerts(KeyStoreHolder ksh, boolean allowInsecureConnection, Certificate[] trustCertficates, Provider securityProvider) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManager[] trustManagers;
        if (allowInsecureConnection) {
            trustManagers = InsecureTrustManagerFactory.INSTANCE.getTrustManagers();
        } else {
            TrustManagerFactory tmf;
            TrustManagerFactory trustManagerFactory = tmf = securityProvider != null ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), securityProvider) : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (trustCertficates == null || trustCertficates.length == 0) {
                tmf.init((KeyStore)null);
            } else {
                for (int i = 0; i < trustCertficates.length; ++i) {
                    ksh.setCertificate("trust" + i, trustCertficates[i]);
                }
                tmf.init(ksh.getKeyStore());
            }
            for (TrustManager trustManager : trustManagers = tmf.getTrustManagers()) {
                SecurityUtility.processConscryptTrustManager(trustManager);
            }
        }
        return trustManagers;
    }

    @InterfaceAudience.Private
    public static TrustManager[] processConscryptTrustManagers(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            SecurityUtility.processConscryptTrustManager(trustManager);
        }
        return trustManagers;
    }

    private static void processConscryptTrustManager(TrustManager trustManager) {
        if (trustManager.getClass().getName().equals("org.conscrypt.TrustManagerImpl")) {
            try {
                Object defaultHostnameVerifier;
                Class<?> conscryptClazz = Class.forName("org.conscrypt.Conscrypt");
                Object hostnameVerifier = conscryptClazz.getMethod("getHostnameVerifier", TrustManager.class).invoke(null, trustManager);
                if (hostnameVerifier == null && (defaultHostnameVerifier = conscryptClazz.getMethod("getDefaultHostnameVerifier", TrustManager.class).invoke(null, trustManager)) != null) {
                    conscryptClazz.getMethod("setHostnameVerifier", TrustManager.class, Class.forName("org.conscrypt.ConscryptHostnameVerifier")).invoke(null, trustManager, defaultHostnameVerifier);
                }
            }
            catch (ReflectiveOperationException e) {
                log.warn("Unable to set hostname verifier for Conscrypt TrustManager implementation", (Throwable)e);
            }
        }
    }

    public static X509Certificate[] loadCertificatesFromPemFile(String certFilePath) throws KeyManagementException {
        X509Certificate[] certificates = null;
        if (certFilePath == null || certFilePath.isEmpty()) {
            return certificates;
        }
        try (FileInputStream input = new FileInputStream(certFilePath);){
            certificates = SecurityUtility.loadCertificatesFromPemStream(input);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Certificate loading error", e);
        }
        return certificates;
    }

    public static X509Certificate[] loadCertificatesFromPemStream(InputStream inStream) throws KeyManagementException {
        if (inStream == null) {
            return null;
        }
        try {
            if (inStream.markSupported()) {
                inStream.reset();
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(inStream);
            return collection.toArray(new X509Certificate[collection.size()]);
        }
        catch (IOException | CertificateException e) {
            throw new KeyManagementException("Certificate loading error", e);
        }
    }

    public static PrivateKey loadPrivateKeyFromPemFile(String keyFilePath) throws KeyManagementException {
        PrivateKey privateKey;
        if (keyFilePath == null || keyFilePath.isEmpty()) {
            return null;
        }
        try (FileInputStream input = new FileInputStream(keyFilePath);){
            privateKey = SecurityUtility.loadPrivateKeyFromPemStream(input);
        }
        catch (IOException e) {
            throw new KeyManagementException("Private key loading error", e);
        }
        return privateKey;
    }

    public static PrivateKey loadPrivateKeyFromPemStream(InputStream inStream) throws KeyManagementException {
        PrivateKey privateKey;
        if (inStream == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            if (inStream.markSupported()) {
                inStream.reset();
            }
            StringBuilder sb = new StringBuilder();
            String currentLine = null;
            while ((currentLine = reader.readLine()) != null && !currentLine.startsWith("-----BEGIN")) {
                reader.readLine();
            }
            while ((currentLine = reader.readLine()) != null && !currentLine.startsWith("-----END")) {
                sb.append(currentLine);
            }
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(sb.toString()));
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KeyManagementException("Private key loading error", e);
        }
        return privateKey;
    }

    private static void setupTrustCerts(SslContextBuilder builder, boolean allowInsecureConnection, InputStream trustCertsStream) throws IOException, FileNotFoundException {
        if (allowInsecureConnection) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (trustCertsStream != null) {
            builder.trustManager(trustCertsStream);
        } else {
            builder.trustManager((File)null);
        }
    }

    private static void setupKeyManager(SslContextBuilder builder, PrivateKey privateKey, X509Certificate[] certificates) {
        builder.keyManager(privateKey, certificates);
    }

    private static void setupCiphers(SslContextBuilder builder, Set<String> ciphers) {
        if (ciphers != null && ciphers.size() > 0) {
            builder.ciphers(ciphers);
        }
    }

    private static void setupProtocols(SslContextBuilder builder, Set<String> protocols) {
        if (protocols != null && protocols.size() > 0) {
            builder.protocols(protocols.toArray(new String[protocols.size()]));
        }
    }

    private static void setupClientAuthentication(SslContextBuilder builder, boolean requireTrustedClientCertOnConnect) {
        if (requireTrustedClientCertOnConnect) {
            builder.clientAuth(ClientAuth.REQUIRE);
        } else {
            builder.clientAuth(ClientAuth.OPTIONAL);
        }
    }

    public static void configureSSLHandler(SslHandler handler) {
        SSLEngine sslEngine = handler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
    }

    public static Provider resolveProvider(String providerName) throws NoSuchAlgorithmException {
        Provider provider = null;
        if (!StringUtils.isEmpty(providerName)) {
            provider = Security.getProvider(providerName);
        }
        if (provider == null) {
            provider = SSLContext.getDefault().getProvider();
        }
        return provider;
    }
}

