/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Runnables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Runnables.class);

    private Runnables() {
    }

    public static Runnable catchingAndLoggingThrowables(Runnable runnable) {
        return new CatchingAndLoggingRunnable(runnable);
    }

    private static final class CatchingAndLoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        private CatchingAndLoggingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t2) {
                LOGGER.error("Unexpected throwable caught", t2);
            }
        }
    }
}

