/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.v3_0_8.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.v3_0_8.common.util.SecurityUtility;
import org.apache.pulsar.v3_0_8.common.util.SslContextAutoRefreshBuilder;

public class DefaultSslContextBuilder
extends SslContextAutoRefreshBuilder<SSLContext> {
    private volatile SSLContext sslContext;
    protected final boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertificateFilePath;
    protected final FileModifiedTimeUpdater tlsKeyFilePath;
    protected final boolean tlsRequireTrustedClientCertOnConnect;
    private final String providerName;

    public DefaultSslContextBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, boolean requireTrustedClientCertOnConnect, long certRefreshInSec) {
        super(certRefreshInSec);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(certificateFilePath);
        this.tlsKeyFilePath = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.providerName = null;
    }

    public DefaultSslContextBuilder(boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, boolean requireTrustedClientCertOnConnect, long certRefreshInSec, String providerName) {
        super(certRefreshInSec);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(certificateFilePath);
        this.tlsKeyFilePath = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.providerName = providerName;
    }

    @Override
    public synchronized SSLContext update() throws GeneralSecurityException {
        this.sslContext = SecurityUtility.createSslContext(this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.providerName);
        return this.sslContext;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyFilePath.checkAndRefresh();
    }
}

