/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateFormatter {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    public static String now() {
        return DateFormatter.format(Instant.now());
    }

    public static String format(long timestamp) {
        return DateFormatter.format(Instant.ofEpochMilli(timestamp));
    }

    public static String format(Instant instant) {
        return DATE_FORMAT.format(instant);
    }

    public static long parse(String datetime) throws DateTimeParseException {
        Instant instant = Instant.from(DATE_FORMAT.parse(datetime));
        return instant.toEpochMilli();
    }

    private DateFormatter() {
    }
}

