/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.stats;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.pulsar.v3_0_8.common.stats.JvmGCMetricsLogger;
import org.apache.pulsar.v3_0_8.common.stats.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmG1GCMetricsLogger
implements JvmGCMetricsLogger {
    private volatile long accumulatedYoungGcCount = 0L;
    private volatile long currentYoungGcCount = 0L;
    private volatile long accumulatedYoungGcTime = 0L;
    private volatile long currentYoungGcTime = 0L;
    private volatile long accumulatedOldGcCount = 0L;
    private volatile long currentOldGcCount = 0L;
    private volatile long accumulatedOldGcTime = 0L;
    private volatile long currentOldGcTime = 0L;
    private static ObjectName youngGenName = null;
    private static ObjectName oldGenName = null;
    private static final Logger log;

    @Override
    public void logMetrics(Metrics metrics) {
        metrics.put("jvm_gc_young_pause", this.currentYoungGcTime);
        metrics.put("jvm_gc_young_count", this.currentYoungGcCount);
        metrics.put("jvm_gc_old_pause", this.currentOldGcTime);
        metrics.put("jvm_gc_old_count", this.currentOldGcCount);
    }

    @Override
    public void refresh() {
        MBeanServer s2 = ManagementFactory.getPlatformMBeanServer();
        try {
            long newValueYoungGcCount = (Long)s2.getAttribute(youngGenName, "CollectionCount");
            long newValueYoungGcTime = (Long)s2.getAttribute(youngGenName, "CollectionTime");
            this.currentYoungGcCount = newValueYoungGcCount - this.accumulatedYoungGcCount;
            this.currentYoungGcTime = newValueYoungGcTime - this.accumulatedYoungGcTime;
            this.accumulatedYoungGcCount = newValueYoungGcCount;
            this.accumulatedYoungGcTime = newValueYoungGcTime;
            long newValueOldGcCount = (Long)s2.getAttribute(oldGenName, "CollectionCount");
            long newValueOldGcTime = (Long)s2.getAttribute(oldGenName, "CollectionTime");
            this.currentOldGcCount = newValueOldGcCount - this.accumulatedOldGcCount;
            this.currentOldGcTime = newValueOldGcTime - this.accumulatedOldGcTime;
            this.accumulatedOldGcCount = newValueOldGcCount;
            this.accumulatedOldGcTime = newValueOldGcTime;
        }
        catch (Exception e) {
            log.error("Failed to collect GC stats: {}", (Object)e.getMessage());
        }
    }

    static {
        try {
            youngGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Young Generation");
            oldGenName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Old Generation");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        log = LoggerFactory.getLogger(JvmG1GCMetricsLogger.class);
    }
}

