/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.policies.data;

import org.apache.pulsar.v3_0_8.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;

public enum SchemaCompatibilityStrategy {
    UNDEFINED,
    ALWAYS_INCOMPATIBLE,
    ALWAYS_COMPATIBLE,
    BACKWARD,
    FORWARD,
    FULL,
    BACKWARD_TRANSITIVE,
    FORWARD_TRANSITIVE,
    FULL_TRANSITIVE;


    public static boolean isUndefined(SchemaCompatibilityStrategy strategy) {
        return strategy == null || strategy == UNDEFINED;
    }

    public static SchemaCompatibilityStrategy fromAutoUpdatePolicy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        if (strategy == null) {
            return null;
        }
        switch (strategy) {
            case Backward: {
                return BACKWARD;
            }
            case Forward: {
                return FORWARD;
            }
            case Full: {
                return FULL;
            }
            case AlwaysCompatible: {
                return ALWAYS_COMPATIBLE;
            }
            case ForwardTransitive: {
                return FORWARD_TRANSITIVE;
            }
            case BackwardTransitive: {
                return BACKWARD_TRANSITIVE;
            }
            case FullTransitive: {
                return FULL_TRANSITIVE;
            }
        }
        return ALWAYS_INCOMPATIBLE;
    }
}

