/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.policies.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum OffloadedReadPriority {
    BOOKKEEPER_FIRST("bookkeeper-first"),
    TIERED_STORAGE_FIRST("tiered-storage-first");

    private final String value;

    private OffloadedReadPriority(String value) {
        this.value = value;
    }

    public boolean equalsName(String otherName) {
        return this.value.equals(otherName);
    }

    public String toString() {
        return this.value;
    }

    public static OffloadedReadPriority fromString(String str) {
        for (OffloadedReadPriority value : OffloadedReadPriority.values()) {
            if (!value.value.equals(str)) continue;
            return value;
        }
        throw new IllegalArgumentException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + str);
    }

    public String getValue() {
        return this.value;
    }
}

