/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.policies.data;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.v3_0_8.common.util.ObjectMapperFactory;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.ObjectReader;

public class EnsemblePlacementPolicyConfig {
    public static final String ENSEMBLE_PLACEMENT_POLICY_CONFIG = "EnsemblePlacementPolicyConfig";
    private final Class policyClass;
    private final Map<String, Object> properties;
    private static final ObjectReader ENSEMBLE_PLACEMENT_CONFIG_READER = ObjectMapperFactory.getMapper().reader().forType(EnsemblePlacementPolicyConfig.class);

    private EnsemblePlacementPolicyConfig() {
        this.policyClass = null;
        this.properties = Collections.emptyMap();
    }

    public EnsemblePlacementPolicyConfig(Class policyClass, Map<String, Object> properties) {
        this.policyClass = policyClass;
        this.properties = properties;
    }

    public Class getPolicyClass() {
        return this.policyClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hash(this.policyClass != null ? this.policyClass.getName() : "", this.properties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnsemblePlacementPolicyConfig) {
            EnsemblePlacementPolicyConfig other = (EnsemblePlacementPolicyConfig)obj;
            return Objects.equals(this.policyClass == null ? null : this.policyClass.getName(), other.policyClass == null ? null : other.policyClass.getName()) && Objects.equals(this.properties, other.properties);
        }
        return false;
    }

    public byte[] encode() throws ParseEnsemblePlacementPolicyConfigException {
        try {
            return ObjectMapperFactory.getMapper().writer().withDefaultPrettyPrinter().writeValueAsString(this).getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new ParseEnsemblePlacementPolicyConfigException("Failed to encode to json", e);
        }
    }

    public static EnsemblePlacementPolicyConfig decode(byte[] data) throws ParseEnsemblePlacementPolicyConfigException {
        try {
            return (EnsemblePlacementPolicyConfig)ENSEMBLE_PLACEMENT_CONFIG_READER.readValue(data);
        }
        catch (IOException e) {
            throw new ParseEnsemblePlacementPolicyConfigException("Failed to decode from json", e);
        }
    }

    public static class ParseEnsemblePlacementPolicyConfigException
    extends Exception {
        ParseEnsemblePlacementPolicyConfigException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }
}

