/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.functions;

import lombok.Generated;

public class Resources {
    private static final Resources DEFAULT = new Resources();
    private Double cpu = 1.0;
    private Long ram = 0x40000000L;
    private Long disk = 0x280000000L;

    public static Resources getDefaultResources() {
        return DEFAULT;
    }

    public static Resources mergeWithDefault(Resources resources) {
        if (resources == null) {
            return DEFAULT;
        }
        double cpu = resources.getCpu() == null ? Resources.getDefaultResources().getCpu() : resources.getCpu();
        long ram = resources.getRam() == null ? Resources.getDefaultResources().getRam() : resources.getRam();
        long disk = resources.getDisk() == null ? Resources.getDefaultResources().getDisk() : resources.getDisk();
        return new Resources(cpu, ram, disk);
    }

    @Generated
    public static ResourcesBuilder builder() {
        return new ResourcesBuilder();
    }

    @Generated
    public ResourcesBuilder toBuilder() {
        return new ResourcesBuilder().cpu(this.cpu).ram(this.ram).disk(this.disk);
    }

    @Generated
    public Double getCpu() {
        return this.cpu;
    }

    @Generated
    public Long getRam() {
        return this.ram;
    }

    @Generated
    public Long getDisk() {
        return this.disk;
    }

    @Generated
    public void setCpu(Double cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setRam(Long ram) {
        this.ram = ram;
    }

    @Generated
    public void setDisk(Long disk) {
        this.disk = disk;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resources)) {
            return false;
        }
        Resources other = (Resources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$cpu = this.getCpu();
        Double other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        Long this$ram = this.getRam();
        Long other$ram = other.getRam();
        if (this$ram == null ? other$ram != null : !((Object)this$ram).equals(other$ram)) {
            return false;
        }
        Long this$disk = this.getDisk();
        Long other$disk = other.getDisk();
        return !(this$disk == null ? other$disk != null : !((Object)this$disk).equals(other$disk));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Resources;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        Long $ram = this.getRam();
        result = result * 59 + ($ram == null ? 43 : ((Object)$ram).hashCode());
        Long $disk = this.getDisk();
        result = result * 59 + ($disk == null ? 43 : ((Object)$disk).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Resources(cpu=" + this.getCpu() + ", ram=" + this.getRam() + ", disk=" + this.getDisk() + ")";
    }

    @Generated
    public Resources(Double cpu, Long ram, Long disk) {
        this.cpu = cpu;
        this.ram = ram;
        this.disk = disk;
    }

    @Generated
    public Resources() {
    }

    @Generated
    public static class ResourcesBuilder {
        @Generated
        private Double cpu;
        @Generated
        private Long ram;
        @Generated
        private Long disk;

        @Generated
        ResourcesBuilder() {
        }

        @Generated
        public ResourcesBuilder cpu(Double cpu) {
            this.cpu = cpu;
            return this;
        }

        @Generated
        public ResourcesBuilder ram(Long ram) {
            this.ram = ram;
            return this;
        }

        @Generated
        public ResourcesBuilder disk(Long disk) {
            this.disk = disk;
            return this;
        }

        @Generated
        public Resources build() {
            return new Resources(this.cpu, this.ram, this.disk);
        }

        @Generated
        public String toString() {
            return "Resources.ResourcesBuilder(cpu=" + this.cpu + ", ram=" + this.ram + ", disk=" + this.disk + ")";
        }
    }
}

