/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.v3_0_8.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.v3_0_8.common.compression.AirliftUtils;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodec;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.snappy.SnappyCompressor;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.snappy.SnappyDecompressor;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.snappy.SnappyRawCompressor;
import org.apache.pulsar.v3_0_8.shade.io.airlift.compress.snappy.SnappyRawDecompressor;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.v3_0_8.shade.io.netty.util.concurrent.FastThreadLocal;

public class CompressionCodecSnappy
implements CompressionCodec {
    private static final FastThreadLocal<short[]> SNAPPY_TABLE = new FastThreadLocal<short[]>(){

        @Override
        protected short[] initialValue() throws Exception {
            return new short[16384];
        }
    };
    private static final FastThreadLocal<SnappyCompressor> SNAPPY_COMPRESSOR = new FastThreadLocal<SnappyCompressor>(){

        @Override
        protected SnappyCompressor initialValue() throws Exception {
            return new SnappyCompressor();
        }
    };
    private static final FastThreadLocal<SnappyDecompressor> SNAPPY_DECOMPRESSOR = new FastThreadLocal<SnappyDecompressor>(){

        @Override
        protected SnappyDecompressor initialValue() throws Exception {
            return new SnappyDecompressor();
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = SnappyRawCompressor.maxCompressedLength(uncompressedLength);
        ByteBuf target = PulsarByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        if (source.hasMemoryAddress() && target.hasMemoryAddress()) {
            compressedLength = SnappyRawCompressor.compress(null, source.memoryAddress() + (long)source.readerIndex(), source.memoryAddress() + (long)source.writerIndex(), null, target.memoryAddress(), target.memoryAddress() + (long)maxLength, SNAPPY_TABLE.get());
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            SNAPPY_COMPRESSOR.get().compress(sourceNio, targetNio);
            compressedLength = targetNio.position();
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress() && uncompressed.hasMemoryAddress()) {
            SnappyRawDecompressor.decompress(null, encoded.memoryAddress() + (long)encoded.readerIndex(), encoded.memoryAddress() + (long)encoded.writerIndex(), null, uncompressed.memoryAddress(), uncompressed.memoryAddress() + (long)uncompressedLength);
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            encodedNio = AirliftUtils.ensureAirliftSupported(encodedNio);
            SNAPPY_DECOMPRESSOR.get().decompress(encodedNio, uncompressedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

