/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.compression;

import java.util.EnumMap;
import lombok.Generated;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodec;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodecLZ4;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodecNone;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodecSnappy;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodecZLib;
import org.apache.pulsar.v3_0_8.common.compression.CompressionCodecZstd;

public final class CompressionCodecProvider {
    private static final EnumMap<org.apache.pulsar.v3_0_8.common.api.proto.CompressionType, CompressionCodec> codecs = new EnumMap(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.class);

    public static CompressionCodec getCompressionCodec(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType type) {
        return codecs.get((Object)type);
    }

    public static CompressionCodec getCompressionCodec(CompressionType type) {
        return codecs.get((Object)CompressionCodecProvider.convertToWireProtocol(type));
    }

    public static org.apache.pulsar.v3_0_8.common.api.proto.CompressionType convertToWireProtocol(CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.NONE;
            }
            case LZ4: {
                return org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.LZ4;
            }
            case ZLIB: {
                return org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.ZLIB;
            }
            case ZSTD: {
                return org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.ZSTD;
            }
            case SNAPPY: {
                return org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.SNAPPY;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    public static CompressionType convertFromWireProtocol(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case ZLIB: {
                return CompressionType.ZLIB;
            }
            case ZSTD: {
                return CompressionType.ZSTD;
            }
            case SNAPPY: {
                return CompressionType.SNAPPY;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    @Generated
    private CompressionCodecProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        codecs.put(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.NONE, new CompressionCodecNone());
        codecs.put(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.LZ4, new CompressionCodecLZ4());
        codecs.put(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.ZLIB, new CompressionCodecZLib());
        codecs.put(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.ZSTD, new CompressionCodecZstd());
        codecs.put(org.apache.pulsar.v3_0_8.common.api.proto.CompressionType.SNAPPY, new CompressionCodecSnappy());
    }
}

