/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.v3_0_8.common.api.proto.KeyValue;
import org.apache.pulsar.v3_0_8.common.api.proto.LightProtoCodec;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.v3_0_8.shade.io.netty.buffer.Unpooled;

public final class Schema {
    private String name;
    private int _nameBufferIdx = -1;
    private int _nameBufferLen = -1;
    private static final int _NAME_FIELD_NUMBER = 1;
    private static final int _NAME_TAG = 10;
    private static final int _NAME_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _NAME_MASK = 1;
    private ByteBuf schemaData = null;
    private int _schemaDataIdx = -1;
    private int _schemaDataLen = -1;
    private static final int _SCHEMA_DATA_FIELD_NUMBER = 3;
    private static final int _SCHEMA_DATA_TAG = 26;
    private static final int _SCHEMA_DATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private static final int _SCHEMA_DATA_MASK = 2;
    private Type type;
    private static final int _TYPE_FIELD_NUMBER = 4;
    private static final int _TYPE_TAG = 32;
    private static final int _TYPE_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _TYPE_MASK = 4;
    private List<KeyValue> properties = null;
    private int _propertiesCount = 0;
    private static final int _PROPERTIES_FIELD_NUMBER = 5;
    private static final int _PROPERTIES_TAG = 42;
    private static final int _PROPERTIES_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 7;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasName() {
        return (this._bitField0 & 1) != 0;
    }

    public String getName() {
        if (!this.hasName()) {
            throw new IllegalStateException("Field 'name' is not set");
        }
        if (this.name == null) {
            this.name = LightProtoCodec.readString(this._parsedBuffer, this._nameBufferIdx, this._nameBufferLen);
        }
        return this.name;
    }

    public Schema setName(String name) {
        this.name = name;
        this._bitField0 |= 1;
        this._nameBufferIdx = -1;
        this._nameBufferLen = LightProtoCodec.computeStringUTF8Size(name);
        this._cachedSize = -1;
        return this;
    }

    public Schema clearName() {
        this._bitField0 &= 0xFFFFFFFE;
        this.name = null;
        this._nameBufferIdx = -1;
        this._nameBufferLen = -1;
        return this;
    }

    public boolean hasSchemaData() {
        return (this._bitField0 & 2) != 0;
    }

    public int getSchemaDataSize() {
        if (!this.hasSchemaData()) {
            throw new IllegalStateException("Field 'schema_data' is not set");
        }
        return this._schemaDataLen;
    }

    public byte[] getSchemaData() {
        ByteBuf _b = this.getSchemaDataSlice();
        byte[] res = new byte[_b.readableBytes()];
        _b.getBytes(0, res);
        return res;
    }

    public ByteBuf getSchemaDataSlice() {
        if (!this.hasSchemaData()) {
            throw new IllegalStateException("Field 'schema_data' is not set");
        }
        if (this.schemaData == null) {
            return this._parsedBuffer.slice(this._schemaDataIdx, this._schemaDataLen);
        }
        return this.schemaData.slice(0, this._schemaDataLen);
    }

    public Schema setSchemaData(byte[] schemaData) {
        this.setSchemaData(Unpooled.wrappedBuffer(schemaData));
        return this;
    }

    public Schema setSchemaData(ByteBuf schemaData) {
        this.schemaData = schemaData;
        this._bitField0 |= 2;
        this._schemaDataIdx = -1;
        this._schemaDataLen = schemaData.readableBytes();
        this._cachedSize = -1;
        return this;
    }

    public Schema clearSchemaData() {
        this._bitField0 &= 0xFFFFFFFD;
        this.schemaData = null;
        this._schemaDataIdx = -1;
        this._schemaDataLen = -1;
        return this;
    }

    public boolean hasType() {
        return (this._bitField0 & 4) != 0;
    }

    public Type getType() {
        if (!this.hasType()) {
            throw new IllegalStateException("Field 'type' is not set");
        }
        return this.type;
    }

    public Schema setType(Type type) {
        this.type = type;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public Schema clearType() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public int getPropertiesCount() {
        return this._propertiesCount;
    }

    public KeyValue getPropertyAt(int idx) {
        if (idx < 0 || idx >= this._propertiesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._propertiesCount + ") for field 'properties'");
        }
        return this.properties.get(idx);
    }

    public List<KeyValue> getPropertiesList() {
        if (this._propertiesCount == 0) {
            return Collections.emptyList();
        }
        return this.properties.subList(0, this._propertiesCount);
    }

    public KeyValue addProperty() {
        if (this.properties == null) {
            this.properties = new ArrayList<KeyValue>();
        }
        if (this.properties.size() == this._propertiesCount) {
            this.properties.add(new KeyValue());
        }
        this._cachedSize = -1;
        return this.properties.get(this._propertiesCount++);
    }

    public Schema addAllProperties(Iterable<KeyValue> properties) {
        for (KeyValue _o : properties) {
            this.addProperty().copyFrom(_o);
        }
        return this;
    }

    public Schema clearProperties() {
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._nameBufferLen);
        if (this._nameBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.name, this._nameBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._nameBufferIdx, _b, this._nameBufferLen);
        }
        LightProtoCodec.writeVarInt(_b, 26);
        LightProtoCodec.writeVarInt(_b, this._schemaDataLen);
        if (this._schemaDataIdx == -1) {
            _b.writeBytes(this.schemaData);
        } else {
            this._parsedBuffer.getBytes(this._schemaDataIdx, _b, this._schemaDataLen);
        }
        LightProtoCodec.writeVarInt(_b, 32);
        LightProtoCodec.writeVarInt(_b, this.type.getValue());
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _NAME_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._nameBufferLen);
        _size += this._nameBufferLen;
        _size += _SCHEMA_DATA_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._schemaDataLen) + this._schemaDataLen;
        _size += _TYPE_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this.type.getValue());
        for (int i = 0; i < this._propertiesCount; ++i) {
            KeyValue _item = this.properties.get(i);
            _size += _PROPERTIES_TAG_SIZE;
            int MsgsizeProperties = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeProperties) + MsgsizeProperties;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block6: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._nameBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._nameBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._nameBufferLen);
                    continue block6;
                }
                case 26: {
                    this._bitField0 |= 2;
                    this._schemaDataLen = LightProtoCodec.readVarInt(_buffer);
                    this._schemaDataIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._schemaDataLen);
                    continue block6;
                }
                case 32: {
                    Type _type = Type.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_type == null) continue block6;
                    this._bitField0 |= 4;
                    this.type = _type;
                    continue block6;
                }
                case 42: {
                    int _propertiesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addProperty().parseFrom(_buffer, _propertiesSize);
                    continue block6;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 7) != 7) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public Schema clear() {
        this.name = null;
        this._nameBufferIdx = -1;
        this._nameBufferLen = -1;
        this.schemaData = null;
        this._schemaDataIdx = -1;
        this._schemaDataLen = -1;
        for (int i = 0; i < this._propertiesCount; ++i) {
            this.properties.get(i).clear();
        }
        this._propertiesCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public Schema copyFrom(Schema _other) {
        this._cachedSize = -1;
        if (_other.hasName()) {
            this.setName(_other.getName());
        }
        if (_other.hasSchemaData()) {
            this.setSchemaData(_other.getSchemaData());
        }
        if (_other.hasType()) {
            this.setType(_other.type);
        }
        for (int i = 0; i < _other.getPropertiesCount(); ++i) {
            this.addProperty().copyFrom(_other.getPropertyAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }

    public static enum Type {
        None(0),
        String(1),
        Json(2),
        Protobuf(3),
        Avro(4),
        Bool(5),
        Int8(6),
        Int16(7),
        Int32(8),
        Int64(9),
        Float(10),
        Double(11),
        Date(12),
        Time(13),
        Timestamp(14),
        KeyValue(15),
        Instant(16),
        LocalDate(17),
        LocalTime(18),
        LocalDateTime(19),
        ProtobufNative(20),
        AutoConsume(21);

        private final int value;
        public static final int None_VALUE = 0;
        public static final int String_VALUE = 1;
        public static final int Json_VALUE = 2;
        public static final int Protobuf_VALUE = 3;
        public static final int Avro_VALUE = 4;
        public static final int Bool_VALUE = 5;
        public static final int Int8_VALUE = 6;
        public static final int Int16_VALUE = 7;
        public static final int Int32_VALUE = 8;
        public static final int Int64_VALUE = 9;
        public static final int Float_VALUE = 10;
        public static final int Double_VALUE = 11;
        public static final int Date_VALUE = 12;
        public static final int Time_VALUE = 13;
        public static final int Timestamp_VALUE = 14;
        public static final int KeyValue_VALUE = 15;
        public static final int Instant_VALUE = 16;
        public static final int LocalDate_VALUE = 17;
        public static final int LocalTime_VALUE = 18;
        public static final int LocalDateTime_VALUE = 19;
        public static final int ProtobufNative_VALUE = 20;
        public static final int AutoConsume_VALUE = 21;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type valueOf(int n) {
            switch (n) {
                case 0: {
                    return None;
                }
                case 1: {
                    return String;
                }
                case 2: {
                    return Json;
                }
                case 3: {
                    return Protobuf;
                }
                case 4: {
                    return Avro;
                }
                case 5: {
                    return Bool;
                }
                case 6: {
                    return Int8;
                }
                case 7: {
                    return Int16;
                }
                case 8: {
                    return Int32;
                }
                case 9: {
                    return Int64;
                }
                case 10: {
                    return Float;
                }
                case 11: {
                    return Double;
                }
                case 12: {
                    return Date;
                }
                case 13: {
                    return Time;
                }
                case 14: {
                    return Timestamp;
                }
                case 15: {
                    return KeyValue;
                }
                case 16: {
                    return Instant;
                }
                case 17: {
                    return LocalDate;
                }
                case 18: {
                    return LocalTime;
                }
                case 19: {
                    return LocalDateTime;
                }
                case 20: {
                    return ProtobufNative;
                }
                case 21: {
                    return AutoConsume;
                }
            }
            return null;
        }
    }
}

