/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.util;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ObjectCache<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private T cachedInstance;
    private final long cacheDurationMillis;
    private long lastRefreshTimestamp;
    private final Clock clock;

    public ObjectCache(Supplier<T> supplier, long cacheDuration, TimeUnit unit) {
        this(supplier, cacheDuration, unit, Clock.systemUTC());
    }

    ObjectCache(Supplier<T> supplier, long cacheDuration, TimeUnit unit, Clock clock) {
        this.supplier = supplier;
        this.cachedInstance = null;
        this.cacheDurationMillis = unit.toMillis(cacheDuration);
        this.clock = clock;
    }

    @Override
    public synchronized T get() {
        long now = this.clock.millis();
        if (this.cachedInstance == null || now - this.lastRefreshTimestamp >= this.cacheDurationMillis) {
            this.cachedInstance = this.supplier.get();
            this.lastRefreshTimestamp = now;
        }
        return this.cachedInstance;
    }
}

