/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema.reader;

import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaUtils;
import org.apache.pulsar.v3_0_8.client.impl.schema.reader.AbstractMultiVersionAvroBaseReader;
import org.apache.pulsar.v3_0_8.client.impl.schema.reader.AvroReader;
import org.apache.pulsar.v3_0_8.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.v3_0_8.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionAvroReader<T>
extends AbstractMultiVersionAvroBaseReader<T> {
    private final ClassLoader pojoClassLoader;
    protected static final Logger LOG = LoggerFactory.getLogger(MultiVersionAvroReader.class);

    public MultiVersionAvroReader(Schema readerSchema, ClassLoader pojoClassLoader, boolean jsr310ConversionEnabled) {
        super(new AvroReader(readerSchema, pojoClassLoader, jsr310ConversionEnabled), readerSchema);
        this.pojoClassLoader = pojoClassLoader;
    }

    @Override
    protected SchemaReader<T> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Load schema reader for version({}), schema is : {}, schemaInfo: {}", new Object[]{SchemaUtils.getStringSchemaVersion(schemaVersion.get()), schemaInfo.getSchemaDefinition(), schemaInfo});
            }
            boolean jsr310ConversionEnabled = SchemaUtil.getJsr310ConversionEnabledFromSchemaInfo(schemaInfo);
            return new AvroReader(SchemaUtil.parseAvroSchema(schemaInfo.getSchemaDefinition()), this.readerSchema, this.pojoClassLoader, jsr310ConversionEnabled);
        }
        LOG.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.readerSchema);
        return this.providerSchemaReader;
    }
}

