/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema.generic;

import com.google.protobuf.Descriptors;
import lombok.Generated;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.v3_0_8.client.impl.schema.ProtobufNativeSchemaUtils;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaUtils;
import org.apache.pulsar.v3_0_8.client.impl.schema.generic.GenericProtobufNativeReader;
import org.apache.pulsar.v3_0_8.client.impl.schema.reader.AbstractMultiVersionReader;
import org.apache.pulsar.v3_0_8.common.protocol.schema.BytesSchemaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionGenericProtobufNativeReader
extends AbstractMultiVersionReader<GenericRecord>
implements SchemaReader<GenericRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiVersionGenericProtobufNativeReader.class);
    private final boolean useProvidedSchemaAsReaderSchema;
    private final SchemaInfo schemaInfo;
    private final Descriptors.Descriptor descriptor;

    public MultiVersionGenericProtobufNativeReader(boolean useProvidedSchemaAsReaderSchema, SchemaInfo schemaInfo) {
        super(new GenericProtobufNativeReader(MultiVersionGenericProtobufNativeReader.parseProtobufSchema(schemaInfo)));
        this.useProvidedSchemaAsReaderSchema = useProvidedSchemaAsReaderSchema;
        this.schemaInfo = schemaInfo;
        this.descriptor = (Descriptors.Descriptor)this.providerSchemaReader.getNativeSchema().orElseThrow(() -> {
            log.error("No protobuf native reader found.");
            return new IllegalArgumentException("No protobuf native reader found.");
        });
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo);
            Descriptors.Descriptor recordDescriptor = MultiVersionGenericProtobufNativeReader.parseProtobufSchema(schemaInfo);
            Descriptors.Descriptor readerSchemaDescriptor = this.useProvidedSchemaAsReaderSchema ? this.descriptor : recordDescriptor;
            return new GenericProtobufNativeReader(readerSchemaDescriptor, schemaVersion.get());
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.schemaInfo);
        return this.providerSchemaReader;
    }

    protected static Descriptors.Descriptor parseProtobufSchema(SchemaInfo schemaInfo) {
        return ProtobufNativeSchemaUtils.deserialize(schemaInfo.getSchema());
    }
}

