/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema.generic;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.v3_0_8.client.impl.schema.generic.GenericJsonRecord;
import org.apache.pulsar.v3_0_8.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.v3_0_8.common.util.ObjectMapperFactory;
import org.apache.pulsar.v3_0_8.shade.com.fasterxml.jackson.databind.JsonNode;

public class JsonRecordBuilderImpl
implements GenericRecordBuilder {
    private final GenericSchemaImpl genericSchema;
    private Map<String, Object> map = new HashMap<String, Object>();

    public JsonRecordBuilderImpl(GenericSchemaImpl genericSchema) {
        this.genericSchema = genericSchema;
    }

    public GenericRecordBuilder set(String fieldName, Object value) {
        if (value instanceof GenericRecord) {
            if (!(value instanceof GenericJsonRecord)) {
                throw new IllegalArgumentException("JSON Record Builder doesn't support non-JSON record as a field");
            }
            GenericJsonRecord genericJsonRecord = (GenericJsonRecord)value;
            value = genericJsonRecord.getJsonNode();
        }
        this.map.put(fieldName, value);
        return this;
    }

    public GenericRecordBuilder set(Field field, Object value) {
        this.set(field.getName(), value);
        return this;
    }

    public GenericRecordBuilder clear(String fieldName) {
        this.map.remove(fieldName);
        return this;
    }

    public GenericRecordBuilder clear(Field field) {
        this.clear(field.getName());
        return this;
    }

    public GenericRecord build() {
        Object jn = ObjectMapperFactory.getMapperWithIncludeAlways().getObjectMapper().valueToTree(this.map);
        return new GenericJsonRecord(null, this.genericSchema.getFields(), (JsonNode)jn, null);
    }
}

