/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.api.schema.FieldSchemaBuilder;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.v3_0_8.client.impl.schema.FieldSchemaBuilderImpl;
import org.apache.pulsar.v3_0_8.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.v3_0_8.shade.org.apache.avro.Schema;

public class RecordSchemaBuilderImpl
implements RecordSchemaBuilder {
    public static final String NAMESPACE = "org.apache.pulsar.v3_0_8.schema.record";
    public static final String DEFAULT_SCHEMA_NAME = "PulsarDefault";
    private final String name;
    private final Map<String, String> properties;
    private final List<FieldSchemaBuilderImpl> fields = new ArrayList<FieldSchemaBuilderImpl>();
    private String doc;

    public RecordSchemaBuilderImpl(String name) {
        this.name = name;
        this.properties = new HashMap<String, String>();
    }

    public RecordSchemaBuilder property(String name, String val) {
        this.properties.put(name, val);
        return this;
    }

    public FieldSchemaBuilder field(String fieldName) {
        FieldSchemaBuilderImpl field = new FieldSchemaBuilderImpl(fieldName);
        this.fields.add(field);
        return field;
    }

    public FieldSchemaBuilder field(String fieldName, GenericSchema genericSchema) {
        FieldSchemaBuilderImpl field = new FieldSchemaBuilderImpl(fieldName, genericSchema);
        this.fields.add(field);
        return field;
    }

    public RecordSchemaBuilder doc(String doc) {
        this.doc = doc;
        return this;
    }

    public SchemaInfo build(SchemaType schemaType) {
        switch (schemaType) {
            case JSON: 
            case AVRO: {
                break;
            }
            default: {
                throw new RuntimeException("Currently only AVRO and JSON record schema is supported");
            }
        }
        String schemaNs = NAMESPACE;
        String schemaName = DEFAULT_SCHEMA_NAME;
        if (this.name != null) {
            String[] split = RecordSchemaBuilderImpl.splitName(this.name);
            schemaNs = split[0];
            schemaName = split[1];
        }
        Schema baseSchema = Schema.createRecord(schemaName != null ? schemaName : DEFAULT_SCHEMA_NAME, this.doc, schemaNs, false);
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>();
        for (FieldSchemaBuilderImpl field : this.fields) {
            avroFields.add(field.build());
        }
        baseSchema.setFields(avroFields);
        return new SchemaInfoImpl(this.name, baseSchema.toString().getBytes(StandardCharsets.UTF_8), schemaType, System.currentTimeMillis(), this.properties);
    }

    private static String[] splitName(String fullName) {
        String[] result = new String[2];
        int indexLastDot = fullName.lastIndexOf(46);
        if (indexLastDot >= 0) {
            result[0] = fullName.substring(0, indexLastDot);
            result[1] = fullName.substring(indexLastDot + 1);
        } else {
            result[0] = null;
            result[1] = fullName;
        }
        return result;
    }
}

